/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.graph.GraphListenerBase;

public abstract class GraphListenerCounter
extends GraphListenerBase {
    private long addCount = 0L;
    private long deleteCount = 0L;
    private long addTicks = 0L;
    private long deleteTicks = 0L;
    private final int addNotePoint;
    private final int deleteNotePoint;

    public GraphListenerCounter(int addTickCount) {
        this(addTickCount, -1);
    }

    public GraphListenerCounter(int addTickCount, int deleteTickCount) {
        this.addNotePoint = addTickCount;
        this.deleteNotePoint = deleteTickCount;
    }

    public void reset() {
        this.addCount = 0L;
        this.deleteCount = 0L;
    }

    @Override
    public void notifyEvent(Graph source, Object value) {
        super.notifyEvent(source, value);
    }

    @Override
    protected void addEvent(Triple t2) {
        ++this.addCount;
        if (this.addNotePoint > 0 && this.addCount % (long)this.addNotePoint == 0L) {
            ++this.addTicks;
            this.addTick();
        }
    }

    @Override
    protected void deleteEvent(Triple t2) {
        ++this.deleteCount;
        if (this.deleteNotePoint > 0 && this.deleteCount % (long)this.deleteNotePoint == 0L) {
            ++this.deleteTicks;
            this.deleteTick();
        }
    }

    public final int getAddTickSize() {
        return this.addNotePoint;
    }

    public final int getDeleteTickSize() {
        return this.deleteNotePoint;
    }

    public final long getAddCount() {
        return this.addCount;
    }

    public final long getDeleteCount() {
        return this.deleteCount;
    }

    public final long getAddTicks() {
        return this.addTicks;
    }

    public final long getDeleteTicks() {
        return this.deleteTicks;
    }

    protected abstract void deleteTick();

    protected abstract void addTick();
}

