/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Stream;
import org.fcrepo.migration.handlers.ocfl.CountingInputStream;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.ResourceContent;
import org.fcrepo.storage.ocfl.ResourceHeaders;

public class OcflObjectSessionWrapper
implements OcflObjectSession {
    private final OcflObjectSession inner;
    private static final String METRIC_NAME = "fcrepo.storage.ocfl.object";
    private static final String OPERATION = "operation";
    private static final Timer writeTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "write");
    private static final Timer writeHeadersTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "writeHeaders");
    private static final Timer deleteContentTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "deleteContent");
    private static final Timer deleteResourceTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "deleteResource");
    private static final Timer readHeadersTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "readHeaders");
    private static final Timer readContentTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "readContent");
    private static final Timer listVersionsTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "listVersions");
    private static final Timer containsResourceTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "containsResource");
    private static final Timer commitTimer = Metrics.timer("fcrepo.storage.ocfl.object", "operation", "commit");

    public OcflObjectSessionWrapper(OcflObjectSession inner) {
        this.inner = inner;
    }

    @Override
    public String sessionId() {
        return this.inner.sessionId();
    }

    @Override
    public String ocflObjectId() {
        return this.inner.ocflObjectId();
    }

    @Override
    public ResourceHeaders writeResource(ResourceHeaders headers, InputStream content) {
        CountingInputStream countingStream = content != null ? new CountingInputStream(content) : null;
        return writeTimer.record(() -> this.inner.writeResource(headers, countingStream));
    }

    @Override
    public void writeHeaders(ResourceHeaders headers) {
        writeHeadersTimer.record(() -> this.inner.writeHeaders(headers));
    }

    @Override
    public void deleteContentFile(ResourceHeaders headers) {
        deleteContentTimer.record(() -> this.inner.deleteContentFile(headers));
    }

    @Override
    public void deleteResource(String resourceId) {
        deleteResourceTimer.record(() -> this.inner.deleteResource(resourceId));
    }

    @Override
    public boolean containsResource(String resourceId) {
        return containsResourceTimer.record(() -> this.inner.containsResource(resourceId));
    }

    @Override
    public ResourceHeaders readHeaders(String resourceId) {
        return readHeadersTimer.record(() -> this.inner.readHeaders(resourceId));
    }

    @Override
    public ResourceHeaders readHeaders(String resourceId, String versionNumber) {
        return readHeadersTimer.record(() -> this.inner.readHeaders(resourceId, versionNumber));
    }

    @Override
    public ResourceContent readContent(String resourceId) {
        return readContentTimer.record(() -> this.inner.readContent(resourceId));
    }

    @Override
    public ResourceContent readContent(String resourceId, String versionNumber) {
        return readContentTimer.record(() -> this.inner.readContent(resourceId, versionNumber));
    }

    @Override
    public List<OcflVersionInfo> listVersions(String resourceId) {
        return listVersionsTimer.record(() -> this.inner.listVersions(resourceId));
    }

    @Override
    public Stream<ResourceHeaders> streamResourceHeaders() {
        return this.inner.streamResourceHeaders();
    }

    @Override
    public void versionCreationTimestamp(OffsetDateTime timestamp) {
        this.inner.versionCreationTimestamp(timestamp);
    }

    @Override
    public void versionAuthor(String name, String address) {
        this.inner.versionAuthor(name, address);
    }

    @Override
    public void versionMessage(String message) {
        this.inner.versionMessage(message);
    }

    @Override
    public void invalidateCache(String objectId) {
        this.inner.invalidateCache(objectId);
    }

    @Override
    public void commitType(CommitType commitType) {
        this.inner.commitType(commitType);
    }

    @Override
    public void commit() {
        commitTimer.record(this.inner::commit);
    }

    @Override
    public void abort() {
        this.inner.abort();
    }

    @Override
    public void rollback() {
        this.inner.rollback();
    }

    @Override
    public boolean isOpen() {
        return this.inner.isOpen();
    }

    @Override
    public void close() {
        this.inner.close();
    }
}

