/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.ui.context.HierarchicalThemeSource;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.DelegatingThemeSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;

public abstract class UiApplicationContextUtils {
    public static final String THEME_SOURCE_BEAN_NAME = "themeSource";
    private static final Log logger = LogFactory.getLog(UiApplicationContextUtils.class);

    public static ThemeSource initThemeSource(ApplicationContext context2) {
        if (context2.containsLocalBean(THEME_SOURCE_BEAN_NAME)) {
            HierarchicalThemeSource hts;
            ThemeSource themeSource = context2.getBean(THEME_SOURCE_BEAN_NAME, ThemeSource.class);
            if (context2.getParent() instanceof ThemeSource && themeSource instanceof HierarchicalThemeSource && (hts = (HierarchicalThemeSource)themeSource).getParentThemeSource() == null) {
                hts.setParentThemeSource((ThemeSource)((Object)context2.getParent()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Using ThemeSource [" + themeSource + "]");
            }
            return themeSource;
        }
        HierarchicalThemeSource themeSource = null;
        if (context2.getParent() instanceof ThemeSource) {
            themeSource = new DelegatingThemeSource();
            themeSource.setParentThemeSource((ThemeSource)((Object)context2.getParent()));
        } else {
            themeSource = new ResourceBundleThemeSource();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Unable to locate ThemeSource with name 'themeSource': using default [" + themeSource + "]");
        }
        return themeSource;
    }
}

