/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.core.OcflRepositoryBuilder;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.HashedNTupleLayoutConfig;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMappers;
import edu.wisc.library.ocfl.core.storage.OcflStorageBuilder;
import java.nio.file.Path;
import java.time.Duration;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.handlers.ocfl.PlainOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.DefaultOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.cache.CaffeineCache;
import org.springframework.beans.factory.FactoryBean;

public class OcflSessionFactoryFactoryBean
implements FactoryBean<OcflObjectSessionFactory> {
    private final Path ocflRoot;
    private final Path stagingDir;
    private final MigrationType migrationType;
    private final String user;
    private final String userUri;
    private final DigestAlgorithm digestAlgorithm;
    private final boolean disableChecksumValidation;

    public OcflSessionFactoryFactoryBean(Path ocflRoot, Path stagingDir, MigrationType migrationType, String user, String userUri, DigestAlgorithm digestAlgorithm, boolean disableChecksumValidation) {
        this.ocflRoot = ocflRoot;
        this.stagingDir = stagingDir;
        this.migrationType = migrationType;
        this.user = user;
        this.userUri = userUri;
        this.digestAlgorithm = digestAlgorithm;
        this.disableChecksumValidation = disableChecksumValidation;
    }

    public OcflSessionFactoryFactoryBean(Path ocflRoot, Path stagingDir, MigrationType migrationType, String user, String userUri, boolean disableChecksumValidation) {
        this(ocflRoot, stagingDir, migrationType, user, userUri, DigestAlgorithm.sha512, disableChecksumValidation);
    }

    public OcflObjectSessionFactory getObject() {
        LogicalPathMapper logicalPathMapper = SystemUtils.IS_OS_WINDOWS ? LogicalPathMappers.percentEncodingWindowsMapper() : LogicalPathMappers.percentEncodingLinuxMapper();
        OcflConfig config = new OcflConfig();
        config.setDefaultDigestAlgorithm(this.digestAlgorithm);
        MutableOcflRepository ocflRepo = new OcflRepositoryBuilder().defaultLayoutConfig((OcflExtensionConfig)new HashedNTupleLayoutConfig()).logicalPathMapper(logicalPathMapper).storage(OcflStorageBuilder.builder().fileSystem(this.ocflRoot).build()).workDir(this.stagingDir).ocflConfig(config).buildMutable();
        if (this.migrationType == MigrationType.FEDORA_OCFL) {
            ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
            Cache headersCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(Duration.ofMinutes(10L)).build();
            Cache rootIdCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(Duration.ofMinutes(10L)).build();
            return new DefaultOcflObjectSessionFactory(ocflRepo, this.stagingDir, objectMapper, (org.fcrepo.storage.ocfl.cache.Cache)new CaffeineCache(headersCache), (org.fcrepo.storage.ocfl.cache.Cache)new CaffeineCache(rootIdCache), CommitType.NEW_VERSION, "Generated by Fedora 3 to Fedora 6 migration", this.user, this.userUri);
        }
        return new PlainOcflObjectSessionFactory(ocflRepo, this.stagingDir, "Generated by Fedora 3 to Fedora 6 migration", this.user, this.userUri, this.disableChecksumValidation);
    }

    public Class<?> getObjectType() {
        return OcflObjectSessionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

