/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.exception.OcflInputException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.PersistencePaths;
import org.fcrepo.storage.ocfl.ResourceContent;
import org.fcrepo.storage.ocfl.ResourceHeaders;

public class PlainOcflObjectSession
implements OcflObjectSession {
    private final MutableOcflRepository ocflRepo;
    private final String sessionId;
    private final String ocflObjectId;
    private final VersionInfo versionInfo;
    private final Path objectStaging;
    private final boolean disableChecksumValidation;
    private final OcflOption[] ocflOptions;
    private final HashMap<String, HashMap<String, String>> digests;
    private final Set<String> deletePaths;
    private boolean closed = false;

    public PlainOcflObjectSession(String sessionId, MutableOcflRepository ocflRepo, String ocflObjectId, Path objectStaging, boolean disableChecksumValidation) {
        this.sessionId = sessionId;
        this.ocflRepo = ocflRepo;
        this.ocflObjectId = ocflObjectId;
        this.objectStaging = objectStaging;
        this.disableChecksumValidation = disableChecksumValidation;
        this.versionInfo = new VersionInfo();
        this.ocflOptions = new OcflOption[]{OcflOption.MOVE_SOURCE, OcflOption.OVERWRITE};
        this.digests = new HashMap();
        this.deletePaths = new HashSet<String>();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String ocflObjectId() {
        return this.ocflObjectId;
    }

    public synchronized ResourceHeaders writeResource(ResourceHeaders headers, InputStream content) {
        String externalUrl;
        this.enforceOpen();
        PersistencePaths paths = this.resolvePersistencePaths(headers);
        String logicalPath = paths.getContentFilePath();
        String contentPath = this.encode(logicalPath);
        if (!this.disableChecksumValidation && ((externalUrl = headers.getExternalUrl()) == null || externalUrl.isBlank())) {
            Collection headerDigests = headers.getDigests();
            for (URI uri : headerDigests) {
                String[] parts = uri.getSchemeSpecificPart().split(":");
                HashMap<String, String> digestInfo = new HashMap<String, String>();
                digestInfo.put(parts[0], parts[1]);
                this.digests.put(logicalPath, digestInfo);
            }
        }
        Path contentDst = this.createStagingPath(contentPath);
        this.write(content, contentDst);
        return headers;
    }

    public synchronized void writeHeaders(ResourceHeaders headers) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void versionCreationTimestamp(OffsetDateTime timestamp) {
        this.versionInfo.setCreated(timestamp);
    }

    public void versionAuthor(String name, String address) {
        this.versionInfo.setUser(name, address);
    }

    public void versionMessage(String message) {
        this.versionInfo.setMessage(message);
    }

    public void invalidateCache(String objectId) {
        this.ocflRepo.invalidateCache(objectId);
    }

    public synchronized void commit() {
        this.enforceOpen();
        this.closed = true;
        if (Files.exists(this.objectStaging, new LinkOption[0])) {
            this.ocflRepo.updateObject(ObjectVersionId.head((String)this.ocflObjectId), this.versionInfo, updater -> {
                if (Files.exists(this.objectStaging, new LinkOption[0])) {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        this.addDecodedPaths((OcflObjectUpdater)updater, this.ocflOptions);
                    } else {
                        updater.addPath(this.objectStaging, this.ocflOptions);
                    }
                    this.digests.forEach((logicalPath, digestInfo) -> digestInfo.forEach((digestType, digestValue) -> {
                        block2: {
                            try {
                                updater.addFileFixity(logicalPath, DigestAlgorithm.fromOcflName((String)digestType, (String)digestType), digestValue);
                            }
                            catch (OcflInputException e) {
                                if (e.getMessage().contains("not newly added in this update")) break block2;
                                throw e;
                            }
                        }
                    }));
                    updater.clearFixityBlock();
                }
            });
        }
        if (!this.deletePaths.isEmpty()) {
            this.ocflRepo.updateObject(ObjectVersionId.head((String)this.ocflObjectId), this.versionInfo, updater -> this.deletePaths.forEach(arg_0 -> ((OcflObjectUpdater)updater).removeFile(arg_0)));
        }
        this.cleanup();
    }

    public void abort() {
        if (!this.closed) {
            this.closed = true;
            this.cleanup();
        }
    }

    public void close() {
        this.abort();
    }

    public void rollback() {
        throw new UnsupportedOperationException("Rollback is not supported");
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void deleteContentFile(ResourceHeaders headers) {
        this.enforceOpen();
        PersistencePaths paths = this.resolvePersistencePaths(headers);
        this.deletePaths.add(paths.getContentFilePath());
    }

    public void deleteResource(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceHeaders readHeaders(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceHeaders readHeaders(String resourceId, String versionNumber) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceContent readContent(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceContent readContent(String resourceId, String versionNumber) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<OcflVersionInfo> listVersions(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Stream<ResourceHeaders> streamResourceHeaders() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void commitType(CommitType commitType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean containsResource(String resourceId) {
        return this.ocflRepo.containsObject(this.ocflObjectId);
    }

    private Path stagingPath(String path) {
        return this.objectStaging.resolve(path);
    }

    private Path createStagingPath(String path) {
        Path stagingPath = this.stagingPath(path);
        try {
            Files.createDirectories(stagingPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return stagingPath;
    }

    private void write(InputStream content, Path destination) {
        if (content != null) {
            try {
                Files.copy(content, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private PersistencePaths resolvePersistencePaths(ResourceHeaders headers) {
        PersistencePaths paths;
        String resourceId = headers.getId();
        if (InteractionModel.ACL.getUri().equals(headers.getInteractionModel())) {
            throw new UnsupportedOperationException("ACLs are not supported");
        }
        if (InteractionModel.NON_RDF.getUri().equals(headers.getInteractionModel())) {
            paths = PersistencePaths.nonRdfResource((String)this.ocflObjectId, (String)resourceId);
        } else if (headers.getInteractionModel() != null) {
            paths = PersistencePaths.rdfResource((String)this.ocflObjectId, (String)resourceId);
        } else {
            throw new IllegalArgumentException(String.format("Interaction model for resource %s must be populated.", resourceId));
        }
        return paths;
    }

    private String encode(String value) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String encoded = value.contains("/") ? Arrays.stream(value.split("/")).map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8)).collect(Collectors.joining("/")) : URLEncoder.encode(value, StandardCharsets.UTF_8);
            return encoded;
        }
        return value;
    }

    private void addDecodedPaths(OcflObjectUpdater updater, OcflOption ... ocflOptions) {
        try (Stream<Path> paths = Files.walk(this.objectStaging, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String logicalPath = this.windowsStagingPathToLogicalPath((Path)file);
                updater.addPath(file, logicalPath, ocflOptions);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String windowsStagingPathToLogicalPath(Path path) {
        String normalized = this.objectStaging.relativize(path).toString().replace("\\", "/");
        return URLDecoder.decode(normalized, StandardCharsets.UTF_8);
    }

    private void cleanup() {
        if (Files.exists(this.objectStaging, new LinkOption[0])) {
            FileUtils.deleteQuietly((File)this.objectStaging.toFile());
        }
    }

    private void enforceOpen() {
        if (this.closed) {
            throw new IllegalStateException(String.format("Session %s is already closed!", this.sessionId));
        }
    }
}

