/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

public class EnvUtil {
    private static boolean isJDK_N_OrHigher(int n) {
        String javaVersionStr = System.getProperty("java.version", "");
        if (javaVersionStr.isEmpty()) {
            return false;
        }
        int version2 = EnvUtil.getJDKVersion(javaVersionStr);
        return version2 > 0 && n <= version2;
    }

    public static int getJDKVersion(String javaVersionStr) {
        int version2 = 0;
        for (char ch : javaVersionStr.toCharArray()) {
            if (Character.isDigit(ch)) {
                version2 = version2 * 10 + (ch - 48);
                continue;
            }
            if (version2 != 1) break;
            version2 = 0;
        }
        return version2;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK9OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(9);
    }

    public static boolean isJaninoAvailable() {
        ClassLoader classLoader = EnvUtil.class.getClassLoader();
        try {
            Class<?> bindingClass = classLoader.loadClass("org.codehaus.janino.ScriptEvaluator");
            return bindingClass != null;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }
}

