/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.exception.ObjectOutOfSyncException;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.db.ObjectDetailsDatabase;
import edu.wisc.library.ocfl.core.db.OcflObjectDetails;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.inventory.SidecarMapper;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.storage.AbstractOcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.storage.RepositoryConfig;
import java.io.ByteArrayInputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDetailsDbOcflStorage
extends AbstractOcflStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectDetailsDbOcflStorage.class);
    private final ObjectDetailsDatabase objectDetailsDb;
    private final OcflStorage delegate;

    public ObjectDetailsDbOcflStorage(ObjectDetailsDatabase objectDetailsDb, OcflStorage delegate) {
        this.objectDetailsDb = Enforce.notNull(objectDetailsDb, "objectDetailsDb cannot be null");
        this.delegate = Enforce.notNull(delegate, "delegate cannot be null");
    }

    @Override
    protected RepositoryConfig doInitialize(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig) {
        return this.delegate.initializeStorage(ocflVersion, layoutConfig, this.inventoryMapper, this.supportEvaluator);
    }

    @Override
    public Inventory loadInventory(String objectId) {
        this.ensureOpen();
        OcflObjectDetails details = this.objectDetailsDb.retrieveObjectDetails(objectId);
        if (details == null || details.getInventoryBytes() == null) {
            Inventory inventory = this.delegate.loadInventory(objectId);
            if (inventory != null) {
                try {
                    byte[] inventoryBytes = this.delegate.getInventoryBytes(inventory.getId(), inventory.getHead());
                    this.objectDetailsDb.addObjectDetails(inventory, inventory.getInventoryDigest(), inventoryBytes);
                }
                catch (Exception e2) {
                    LOG.warn("Failed to cache inventory for object <{}>", (Object)objectId, (Object)e2);
                }
            }
            return inventory;
        }
        return this.parseInventory(details);
    }

    @Override
    public byte[] getInventoryBytes(String objectId, VersionNum versionNum) {
        return this.delegate.getInventoryBytes(objectId, versionNum);
    }

    @Override
    public void storeNewVersion(Inventory inventory, Path stagingDir, boolean upgradeOcflVersion) {
        this.ensureOpen();
        this.updateDetails(inventory, stagingDir, () -> this.delegate.storeNewVersion(inventory, stagingDir, upgradeOcflVersion));
    }

    @Override
    public Map<String, OcflFileRetriever> getObjectStreams(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        return this.delegate.getObjectStreams(inventory, versionNum);
    }

    @Override
    public void reconstructObjectVersion(Inventory inventory, VersionNum versionNum, Path stagingDir) {
        this.ensureOpen();
        this.delegate.reconstructObjectVersion(inventory, versionNum, stagingDir);
    }

    @Override
    public void purgeObject(String objectId) {
        this.ensureOpen();
        try {
            this.delegate.purgeObject(objectId);
        }
        finally {
            this.safeDeleteDetails(objectId);
        }
    }

    @Override
    public void rollbackToVersion(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        try {
            this.delegate.rollbackToVersion(inventory, versionNum);
        }
        finally {
            this.safeDeleteDetails(inventory.getId());
        }
    }

    @Override
    public void commitMutableHead(Inventory oldInventory, Inventory newInventory, Path stagingDir) {
        this.ensureOpen();
        this.updateDetails(newInventory, stagingDir, () -> this.delegate.commitMutableHead(oldInventory, newInventory, stagingDir));
    }

    @Override
    public void purgeMutableHead(String objectId) {
        this.ensureOpen();
        try {
            this.delegate.purgeMutableHead(objectId);
        }
        finally {
            this.safeDeleteDetails(objectId);
        }
    }

    @Override
    public boolean containsObject(String objectId) {
        this.ensureOpen();
        return this.delegate.containsObject(objectId);
    }

    @Override
    public String objectRootPath(String objectId) {
        this.ensureOpen();
        return this.delegate.objectRootPath(objectId);
    }

    @Override
    public Stream<String> listObjectIds() {
        this.ensureOpen();
        return this.delegate.listObjectIds();
    }

    @Override
    public void exportVersion(ObjectVersionId objectVersionId, Path outputPath) {
        this.ensureOpen();
        this.delegate.exportVersion(objectVersionId, outputPath);
    }

    @Override
    public void exportObject(String objectId, Path outputPath) {
        this.ensureOpen();
        this.delegate.exportObject(objectId, outputPath);
    }

    @Override
    public void importObject(String objectId, Path objectPath) {
        this.ensureOpen();
        this.delegate.importObject(objectId, objectPath);
    }

    @Override
    public ValidationResults validateObject(String objectId, boolean contentFixityCheck) {
        this.ensureOpen();
        return this.delegate.validateObject(objectId, contentFixityCheck);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void invalidateCache(String objectId) {
        this.objectDetailsDb.deleteObjectDetails(objectId);
        this.delegate.invalidateCache(objectId);
    }

    @Override
    public void invalidateCache() {
        this.objectDetailsDb.deleteAllDetails();
        this.delegate.invalidateCache();
    }

    private void updateDetails(Inventory inventory, Path stagingDir, Runnable runnable) {
        Path inventoryPath = ObjectPaths.inventoryPath(stagingDir);
        Path sidecarPath = ObjectPaths.inventorySidecarPath(stagingDir, inventory);
        String digest = SidecarMapper.readDigestRequired(sidecarPath);
        try {
            this.objectDetailsDb.updateObjectDetails(inventory, digest, inventoryPath, runnable);
        }
        catch (ObjectOutOfSyncException e2) {
            this.safeDeleteDetails(inventory.getId());
            throw e2;
        }
    }

    private void safeDeleteDetails(String objectId) {
        try {
            this.objectDetailsDb.deleteObjectDetails(objectId);
        }
        catch (Exception e2) {
            LOG.error("Failed to delete object details for object {}. You may need to manually remove the record from the database.", (Object)objectId, (Object)e2);
        }
    }

    private Inventory parseInventory(OcflObjectDetails details) {
        Inventory inventory = details.getRevisionNum() == null ? this.inventoryMapper.read(details.getObjectRootPath(), details.getDigestAlgorithm(), new ByteArrayInputStream(details.getInventoryBytes())) : this.inventoryMapper.readMutableHead(details.getObjectRootPath(), details.getRevisionNum(), details.getDigestAlgorithm(), new ByteArrayInputStream(details.getInventoryBytes()));
        if (!details.getInventoryDigest().equalsIgnoreCase(inventory.getInventoryDigest())) {
            throw new FixityCheckException(String.format("Expected %s digest: %s; Actual: %s", details.getDigestAlgorithm(), details.getInventoryDigest(), inventory.getInventoryDigest()));
        }
        return inventory;
    }
}

