/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Set;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.TripleBoundary;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphExtract {
    protected final TripleBoundary b;

    public GraphExtract(TripleBoundary b) {
        this.b = b;
    }

    public Graph extract(Node node, Graph graph) {
        return this.extractInto(Factory.createGraphMem(), node, graph);
    }

    public Graph extractInto(Graph toUpdate, Node root2, Graph extractFrom) {
        new Extraction(this.b, toUpdate, extractFrom).extractInto(root2);
        return toUpdate;
    }

    protected static class Extraction {
        protected Graph toUpdate;
        protected Graph extractFrom;
        protected Set<Node> active;
        protected TripleBoundary b;

        Extraction(TripleBoundary b, Graph toUpdate, Graph extractFrom) {
            this.toUpdate = toUpdate;
            this.extractFrom = extractFrom;
            this.active = CollectionFactory.createHashedSet();
            this.b = b;
        }

        public void extractInto(Node root2) {
            this.active.add(root2);
            ExtendedIterator<Triple> it = this.extractFrom.find(root2, Node.ANY, Node.ANY);
            while (it.hasNext()) {
                Triple t2 = (Triple)it.next();
                Node subRoot = t2.getObject();
                this.toUpdate.add(t2);
                if (this.active.contains(subRoot) || this.b.stopAt(t2)) continue;
                this.extractInto(subRoot);
            }
        }
    }
}

