/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.CompositionBase;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Delta
extends CompositionBase
implements Graph {
    private Graph base;
    private Graph additions;
    private Graph deletions;

    public Delta(Graph base) {
        this.base = GraphPlain.plain(base);
        this.additions = GraphPlain.plain();
        this.deletions = GraphPlain.plain();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.base.getCapabilities();
    }

    public Graph getAdditions() {
        return this.additions;
    }

    public Graph getDeletions() {
        return this.deletions;
    }

    @Override
    public void performAdd(Triple t2) {
        if (!this.base.contains(t2)) {
            this.additions.add(t2);
        }
        this.deletions.delete(t2);
    }

    @Override
    public void performDelete(Triple t2) {
        this.additions.delete(t2);
        if (this.base.contains(t2)) {
            this.deletions.add(t2);
        }
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple t2) {
        ExtendedIterator<Triple> iterator = this.base.find(t2).filterDrop(Delta.ifIn(GraphUtil.findAll(this.deletions))).andThen(this.additions.find(t2));
        return SimpleEventManager.notifyingRemove(this, iterator);
    }

    @Override
    public void close() {
        super.close();
        this.base.close();
        this.additions.close();
        this.deletions.close();
    }

    @Override
    public int graphBaseSize() {
        return this.base.size() + this.additions.size() - this.deletions.size();
    }
}

