/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.ArrayBunch;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.HashedTripleBunch;
import org.apache.jena.mem.NodeToTriplesMapBase;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class NodeToTriplesMapMem
extends NodeToTriplesMapBase {
    public NodeToTriplesMapMem(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        super(indexField, f2, f3);
    }

    @Override
    public boolean add(Triple t2) {
        Object o = this.getIndexField(t2);
        TripleBunch s2 = this.bunchMap.get(o);
        if (s2 == null) {
            s2 = new ArrayBunch();
            this.bunchMap.put(o, s2);
        }
        if (s2.contains(t2)) {
            return false;
        }
        if (s2.size() == 9 && s2 instanceof ArrayBunch) {
            s2 = new HashedTripleBunch(s2);
            this.bunchMap.put(o, s2);
        }
        s2.add(t2);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Triple t2) {
        Object o = this.getIndexField(t2);
        TripleBunch s2 = this.bunchMap.get(o);
        if (s2 == null || !s2.contains(t2)) {
            return false;
        }
        s2.remove(t2);
        --this.size;
        if (s2.size() == 0) {
            this.bunchMap.remove(o);
        }
        return true;
    }

    @Override
    public Iterator<Triple> iterator(Object o, HashCommon.NotifyEmpty container2) {
        TripleBunch s2 = this.bunchMap.get(o);
        return s2 == null ? NullIterator.instance() : s2.iterator(container2);
    }

    @Override
    public boolean contains(Triple t2) {
        TripleBunch s2 = this.bunchMap.get(this.getIndexField(t2));
        return s2 == null ? false : s2.contains(t2);
    }

    @Override
    public boolean containsBySameValueAs(Triple t2) {
        TripleBunch s2 = this.bunchMap.get(this.getIndexField(t2));
        return s2 == null ? false : s2.containsBySameValueAs(t2);
    }

    @Override
    public ExtendedIterator<Triple> iterator(Node index, Node n2, Node n3) {
        Object indexValue = index.getIndexingValue();
        TripleBunch s2 = this.bunchMap.get(indexValue);
        if (s2 == null) {
            return NullIterator.instance();
        }
        Predicate<Triple> filter = this.f2.filterOn(n2).and(this.f3.filterOn(n3));
        return WrappedIterator.create(s2.iterator(new NotifyMe(indexValue))).filterKeep(filter);
    }

    protected TripleBunch get(Object index) {
        return this.bunchMap.get(index);
    }

    @Override
    public Iterator<Triple> iteratorForIndexed(Object y) {
        return this.get(y).iterator();
    }

    public class NotifyMe
    implements HashCommon.NotifyEmpty {
        protected final Object key;

        public NotifyMe(Object key) {
            this.key = key;
        }

        @Override
        public void emptied() {
            NodeToTriplesMapMem.this.bunchMap.remove(this.key);
        }
    }
}

