/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.ontology.impl.BooleanClassDescriptionImpl;
import org.apache.jena.rdf.model.Property;

public class UnionClassImpl
extends BooleanClassDescriptionImpl
implements UnionClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new UnionClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to UnionClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            Property union = profile2 == null ? null : profile2.UNION_OF();
            return profile2 != null && profile2.isSupported(node, eg, OntClass.class) && union != null && eg.asGraph().contains(node, union.asNode(), Node.ANY);
        }
    };

    public UnionClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public Property operator() {
        return this.getProfile().UNION_OF();
    }

    @Override
    public String getOperatorName() {
        return "UNION_OF";
    }
}

