/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.riot.system.RiotChars;

public class LangTag {
    public static final int idxLanguage = 0;
    public static final int idxScript = 1;
    public static final int idxRegion = 2;
    public static final int idxVariant = 3;
    public static final int idxExtension = 4;
    private static final int partsLength = 5;
    private static final String languageRE_1 = "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})";
    private static final String languageRE_2 = "[a-zA-Z]{4}";
    private static final String languageRE_3 = "[a-zA-Z]{5,8}";
    private static final String language = "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})|[a-zA-Z]{4}|[a-zA-Z]{5,8}";
    private static final String script = "[a-zA-Z]{4}";
    private static final String region = "[a-zA-Z]{2}|[0-9]{3}";
    private static final String variant = "[a-zA-Z0-9]{5,8}";
    private static final String extension1 = "(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8})";
    private static final String extension = "(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8})(?:-(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8}))*";
    private static final String langtag = String.format("^(%s)(?:-(%s))?(?:-(%s))?(?:-(%s))?(?:-(%s))?$", "(?:[a-zA-Z]{2,3}(?:-[a-zA-Z]{3}){0,3})|[a-zA-Z]{4}|[a-zA-Z]{5,8}", "[a-zA-Z]{4}", "[a-zA-Z]{2}|[0-9]{3}", "[a-zA-Z0-9]{5,8}", "(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8})(?:-(?:[a-zA-Z0-9]-[a-zA-Z0-9]{2,8}))*");
    private static final String privateuseRE = "^[xX](-[a-zA-Z0-9]{1,8})*$";
    private static final String grandfatheredRE = "i(?:-[a-zA-Z0-9]{2,8}){1,2}";
    private static Pattern pattern = Pattern.compile(langtag);
    private static Pattern patternPrivateuse = Pattern.compile("^[xX](-[a-zA-Z0-9]{1,8})*$");
    private static Pattern patternGrandfathered = Pattern.compile("i(?:-[a-zA-Z0-9]{2,8}){1,2}");

    private LangTag() {
    }

    public static boolean check(String languageTag) {
        int len = languageTag.length();
        int idx = 0;
        boolean first = true;
        while (idx < languageTag.length()) {
            int idx2 = LangTag.checkPart(languageTag, idx, first);
            first = false;
            if (idx2 == idx) {
                return false;
            }
            idx = idx2;
            if (idx == len) {
                return true;
            }
            if (languageTag.charAt(idx) != '-') {
                return false;
            }
            if (++idx != len) continue;
            return false;
        }
        return true;
    }

    private static int checkPart(String languageTag, int idx, boolean leader) {
        while (idx < languageTag.length()) {
            char ch = languageTag.charAt(idx);
            if (!(leader ? RiotChars.isA2Z(ch) : RiotChars.isA2ZN(ch))) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }

    public static String[] parse(String languageTag) {
        String[] parts = new String[5];
        String x = pattern.toString();
        Pattern.compile(languageRE_1);
        Matcher m4 = pattern.matcher(languageTag);
        if (!m4.find()) {
            m4 = patternPrivateuse.matcher(languageTag);
            if (m4.find()) {
                parts[4] = m4.group(0);
                return parts;
            }
            m4 = patternGrandfathered.matcher(languageTag);
            if (m4.find()) {
                parts[4] = m4.group(0);
                return parts;
            }
            return null;
        }
        int gc = m4.groupCount();
        for (int i = 0; i < gc; ++i) {
            parts[i] = m4.group(i + 1);
        }
        parts[0] = LangTag.lowercase(parts[0]);
        parts[1] = LangTag.strcase(parts[1]);
        parts[2] = LangTag.strcase(parts[2]);
        parts[3] = LangTag.strcase(parts[3]);
        return parts;
    }

    public static String canonical(String str2) {
        if (str2 == null) {
            return null;
        }
        String[] parts = LangTag.parse(str2);
        String x = LangTag.canonical(parts);
        if (x == null) {
            return str2;
        }
        return x;
    }

    public static String canonical(String[] parts) {
        if (parts == null) {
            return null;
        }
        if (parts[0] == null) {
            return parts[4];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            sb.append("-");
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    private static String strcase(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 2) {
            return LangTag.uppercase(string);
        }
        if (string.length() == 4) {
            return LangTag.titlecase(string);
        }
        return LangTag.lowercase(string);
    }

    private static String lowercase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    private static String uppercase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    private static String titlecase(String string) {
        if (string == null) {
            return null;
        }
        char ch1 = string.charAt(0);
        ch1 = Character.toUpperCase(ch1);
        string = LangTag.lowercase(string.substring(1));
        return ch1 + string;
    }
}

