/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TransactionHandlerView;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphView
extends GraphBase
implements NamedGraph,
Sync {
    private final DatasetGraph dsg;
    private final Node graphName;
    private final TransactionHandlerView transactionHandler;

    public static GraphView createDefaultGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraph(DatasetGraph dsg, Node graphIRI) {
        return new GraphView(dsg, graphIRI);
    }

    public static GraphView createUnionGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.unionGraph);
    }

    protected GraphView(DatasetGraph dsg, Node gn) {
        this.dsg = dsg;
        this.graphName = gn;
        this.transactionHandler = new TransactionHandlerView(dsg);
    }

    @Override
    public Node getGraphName() {
        return this.isDefaultGraph() ? null : this.graphName;
    }

    public DatasetGraph getDataset() {
        return this.dsg;
    }

    protected final boolean isDefaultGraph() {
        return GraphView.isDefaultGraph(this.graphName);
    }

    protected final boolean isUnionGraph() {
        return GraphView.isUnionGraph(this.graphName);
    }

    protected static final boolean isDefaultGraph(Node gn) {
        return gn == null || Quad.isDefaultGraph(gn);
    }

    protected static final boolean isUnionGraph(Node gn) {
        return Quad.isUnionGraph(gn);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return Prefixes.adapt(this.dsg.prefixes());
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m4) {
        if (m4 == null) {
            m4 = Triple.ANY;
        }
        Node s2 = m4.getMatchSubject();
        Node p = m4.getMatchPredicate();
        Node o = m4.getMatchObject();
        return this.graphBaseFind(s2, p, o);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Node s2, Node p, Node o) {
        if (Quad.isUnionGraph(this.graphName)) {
            return this.graphUnionFind(s2, p, o);
        }
        Node g2 = GraphView.graphNode(this.graphName);
        Iter<Triple> iter = G.quads2triples(this.dsg.find(g2, s2, p, o));
        return WrappedIterator.createNoRemove(iter);
    }

    private static Node graphNode(Node gn) {
        return gn == null ? Quad.defaultGraphNodeGenerated : gn;
    }

    protected ExtendedIterator<Triple> graphUnionFind(Node s2, Node p, Node o) {
        Node g2 = GraphView.graphNode(this.graphName);
        Iterator<Quad> iterQuads = this.getDataset().find(g2, s2, p, o);
        Iterator<Triple> iter = G.quads2triples(iterQuads);
        iter = Iter.distinct(iter);
        return WrappedIterator.createNoRemove(iter);
    }

    @Override
    public void performAdd(Triple t2) {
        Node g2 = GraphView.graphNode(this.graphName);
        if (Quad.isUnionGraph(g2)) {
            throw new AddDeniedException("Can't update the union graph of a dataset");
        }
        Node s2 = t2.getSubject();
        Node p = t2.getPredicate();
        Node o = t2.getObject();
        this.dsg.add(g2, s2, p, o);
    }

    @Override
    public void performDelete(Triple t2) {
        Node g2 = GraphView.graphNode(this.graphName);
        if (Quad.isUnionGraph(g2)) {
            throw new DeleteDeniedException("Can't update the union graph of a dataset");
        }
        Node s2 = t2.getSubject();
        Node p = t2.getPredicate();
        Node o = t2.getObject();
        this.dsg.delete(g2, s2, p, o);
    }

    @Override
    public void remove(Node s2, Node p, Node o) {
        if (this.getEventManager().listening()) {
            super.remove(s2, p, o);
            return;
        }
        this.dsg.deleteAny(this.getGraphName(), s2, p, o);
    }

    @Override
    public void clear() {
        Node gn = this.getGraphName();
        if (gn == null) {
            gn = Quad.defaultGraphNodeGenerated;
        }
        this.getDataset().deleteAny(gn, Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    protected int graphBaseSize() {
        return super.graphBaseSize();
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.dsg);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new TransactionHandlerView(this.dsg);
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new GraphViewCapabilities();
        }
        return this.capabilities;
    }

    protected static class GraphViewCapabilities
    implements Capabilities {
        protected GraphViewCapabilities() {
        }

        @Override
        public boolean sizeAccurate() {
            return true;
        }

        @Override
        public boolean addAllowed() {
            return true;
        }

        @Override
        public boolean deleteAllowed() {
            return true;
        }

        @Override
        public boolean handlesLiteralTyping() {
            return false;
        }
    }

    static class GraphViewException
    extends JenaException {
        public GraphViewException() {
        }

        public GraphViewException(String message) {
            super(message);
        }

        public GraphViewException(Throwable cause) {
            super(cause);
        }

        public GraphViewException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

