/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.mem.TransactionalComponent;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.apache.jena.sparql.core.mem.TripleTableForm;
import org.apache.jena.sparql.core.mem.TupleSlot;
import org.apache.jena.sparql.core.mem.TupleTable;

public class TriTable
implements TripleTable {
    private final Map<TripleTableForm, TripleTable> indexBlock = new EnumMap<TripleTableForm, TripleTable>(TripleTableForm.tableForms().collect(Collectors.toMap(x -> x, TripleTableForm::get)));

    protected Map<TripleTableForm, TripleTable> indexBlock() {
        return this.indexBlock;
    }

    @Override
    public void commit() {
        this.indexBlock().values().forEach(TransactionalComponent::commit);
        this.end();
    }

    @Override
    public void abort() {
        this.indexBlock().values().forEach(TupleTable::abort);
        this.end();
    }

    @Override
    public void end() {
        this.indexBlock().values().forEach(TransactionalComponent::end);
    }

    @Override
    public Stream<Triple> find(Node s2, Node p, Node o) {
        EnumSet<TupleSlot> pattern = EnumSet.noneOf(TupleSlot.class);
        if (TriTable.isConcrete(s2)) {
            pattern.add(TupleSlot.SUBJECT);
        }
        if (TriTable.isConcrete(p)) {
            pattern.add(TupleSlot.PREDICATE);
        }
        if (TriTable.isConcrete(o)) {
            pattern.add(TupleSlot.OBJECT);
        }
        TripleTableForm choice = TripleTableForm.chooseFrom(pattern);
        return this.indexBlock().get(choice).find(s2, p, o);
    }

    private static boolean isConcrete(Node n) {
        return Objects.nonNull(n) && n.isConcrete();
    }

    @Override
    public void add(Triple t2) {
        this.indexBlock().values().forEach(index -> index.add(t2));
    }

    @Override
    public void delete(Triple t2) {
        this.indexBlock().values().forEach(index -> index.delete(t2));
    }

    @Override
    public void begin(ReadWrite rw) {
        this.indexBlock().values().forEach(table -> table.begin(rw));
    }

    @Override
    public void clear() {
        this.indexBlock().values().forEach(TripleTable::clear);
    }
}

