/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggMedianDistinct
extends AggregatorBase {
    private static Logger log = LoggerFactory.getLogger("MedianDistinct");
    private static final NodeValue noValuesToMedian = NodeValue.nvZERO;

    public AggMedianDistinct(Expr expr) {
        super("Median", true, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggMedianDistinct(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccMedianDistinct(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToMedian);
    }

    @Override
    public int hashCode() {
        return 0x183 ^ this.getExprList().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggMedianDistinct)) {
            return false;
        }
        AggMedianDistinct a = (AggMedianDistinct)other;
        return this.exprList.equals(a.exprList, bySyntax);
    }

    class AccMedianDistinct
    extends AccumulatorExpr {
        private NodeValue total;
        private int count;
        ArrayList<NodeValue> collection;

        public AccMedianDistinct(Expr expr) {
            super(expr, true);
            this.total = noValuesToMedian;
            this.count = 0;
            this.collection = new ArrayList();
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            log.debug("median {}", (Object)nv);
            if (nv.isNumber()) {
                ++this.count;
            } else {
                throw new ExprEvalException("median: not a number: " + nv);
            }
            this.collection.add(nv);
            log.debug("median count {}", (Object)this.count);
        }

        @Override
        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToMedian;
            }
            if (this.errorCount != 0L) {
                return null;
            }
            int indexsize = this.collection.size();
            double[] arrDouble = new double[indexsize];
            for (int i = 0; i < indexsize; ++i) {
                arrDouble[i] = this.collection.get(i).getDouble();
            }
            Arrays.sort(arrDouble);
            double median = indexsize % 2 != 0 ? arrDouble[indexsize / 2] : (arrDouble[indexsize / 2] + arrDouble[indexsize / 2 - 1]) / 2.0;
            return NodeValue.makeDecimal(median);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

