/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.function.DoubleToLongFunction;
import java.util.function.LongToDoubleFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;

public abstract class DoubleValuesSource {
    public static final DoubleValuesSource SCORES = new DoubleValuesSource(){

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            assert (scores != null);
            return scores;
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) {
            return scoreExplanation;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return "scores";
        }
    };

    public abstract DoubleValues getValues(LeafReaderContext var1, DoubleValues var2) throws IOException;

    public abstract boolean needsScores();

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        DoubleValues dv = this.getValues(ctx, DoubleValuesSource.constant(scoreExplanation.getValue()).getValues(ctx, null));
        if (dv.advanceExact(docId)) {
            return Explanation.match((float)dv.doubleValue(), this.toString(), new Explanation[0]);
        }
        return Explanation.noMatch(this.toString(), new Explanation[0]);
    }

    public SortField getSortField(boolean reverse) {
        return new DoubleValuesSortField(this, reverse);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public final LongValuesSource toLongValuesSource() {
        return new LongDoubleValuesSource(this);
    }

    public static DoubleValuesSource fromField(String field, LongToDoubleFunction decoder) {
        return new FieldValuesSource(field, decoder);
    }

    public static DoubleValuesSource fromDoubleField(String field) {
        return DoubleValuesSource.fromField(field, Double::longBitsToDouble);
    }

    public static DoubleValuesSource fromFloatField(String field) {
        return DoubleValuesSource.fromField(field, v -> Float.intBitsToFloat((int)v));
    }

    public static DoubleValuesSource fromLongField(String field) {
        return DoubleValuesSource.fromField(field, v -> v);
    }

    public static DoubleValuesSource fromIntField(String field) {
        return DoubleValuesSource.fromLongField(field);
    }

    public static DoubleValuesSource constant(double value) {
        return new ConstantValuesSource(value);
    }

    public static DoubleValues fromScorer(final Scorer scorer) {
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                assert (scorer.docID() == doc);
                return true;
            }
        };
    }

    private static NumericDocValues asNumericDocValues(final DoubleValuesHolder in, final DoubleToLongFunction converter) {
        return new NumericDocValues(){

            @Override
            public long longValue() throws IOException {
                return converter.applyAsLong(in.values.doubleValue());
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return in.values.advanceExact(target);
            }

            @Override
            public int docID() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int nextDoc() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class DoubleValuesComparatorSource
    extends FieldComparatorSource {
        private final DoubleValuesSource producer;

        public DoubleValuesComparatorSource(DoubleValuesSource producer) {
            this.producer = producer;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
            return new FieldComparator.DoubleComparator(numHits, fieldname, 0.0){
                LeafReaderContext ctx;
                DoubleValuesHolder holder;
                {
                    super(numHits, field, missingValue);
                    this.holder = new DoubleValuesHolder();
                }

                @Override
                protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                    this.ctx = context2;
                    return DoubleValuesSource.asNumericDocValues(this.holder, Double::doubleToLongBits);
                }

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.holder.values = producer.getValues(this.ctx, DoubleValuesSource.fromScorer(scorer));
                }
            };
        }
    }

    private static class DoubleValuesHolder {
        DoubleValues values;

        private DoubleValuesHolder() {
        }
    }

    private static class DoubleValuesSortField
    extends SortField {
        final DoubleValuesSource producer;

        public DoubleValuesSortField(DoubleValuesSource producer, boolean reverse) {
            super(producer.toString(), new DoubleValuesComparatorSource(producer), reverse);
            this.producer = producer;
        }

        @Override
        public boolean needsScores() {
            return this.producer.needsScores();
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(this.getField()).append(">");
            if (this.reverse) {
                buffer.append("!");
            }
            return buffer.toString();
        }
    }

    private static class FieldValuesSource
    extends DoubleValuesSource {
        final String field;
        final LongToDoubleFunction decoder;

        private FieldValuesSource(String field, LongToDoubleFunction decoder) {
            this.field = field;
            this.decoder = decoder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValuesSource that = (FieldValuesSource)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.decoder, that.decoder);
        }

        @Override
        public String toString() {
            return "double(" + this.field + ")";
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field, this.decoder);
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final NumericDocValues values = DocValues.getNumeric(ctx.reader(), this.field);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return decoder.applyAsDouble(values.longValue());
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            DoubleValues values = this.getValues(ctx, null);
            if (values.advanceExact(docId)) {
                return Explanation.match((float)values.doubleValue(), this.toString(), new Explanation[0]);
            }
            return Explanation.noMatch(this.toString(), new Explanation[0]);
        }
    }

    private static class ConstantValuesSource
    extends DoubleValuesSource {
        private final double value;

        private ConstantValuesSource(double value) {
            this.value = value;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return value;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) {
            return Explanation.match((float)this.value, "constant(" + this.value + ")", new Explanation[0]);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantValuesSource that = (ConstantValuesSource)o;
            return Double.compare(that.value, this.value) == 0;
        }

        @Override
        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    private static class LongDoubleValuesSource
    extends LongValuesSource {
        private final DoubleValuesSource inner;

        private LongDoubleValuesSource(DoubleValuesSource inner) {
            this.inner = inner;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final DoubleValues in = this.inner.getValues(ctx, scores);
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return (long)in.doubleValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return this.inner.needsScores();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongDoubleValuesSource that = (LongDoubleValuesSource)o;
            return Objects.equals(this.inner, that.inner);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.inner);
        }

        @Override
        public String toString() {
            return "long(" + this.inner.toString() + ")";
        }
    }
}

