/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MultiLeafFieldComparator;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    private final boolean fillFields;
    float maxScore = Float.NaN;
    final int numHits;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;
    final boolean needsScores;

    private TopFieldCollector(PriorityQueue<FieldValueHitQueue.Entry> pq, int numHits, boolean fillFields, boolean needsScores) {
        super(pq);
        this.needsScores = needsScores;
        this.numHits = numHits;
        this.fillFields = fillFields;
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    public static TopFieldCollector create(Sort sort, int numHits, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) {
        return TopFieldCollector.create(sort, numHits, null, fillFields, trackDocScores, trackMaxScore);
    }

    public static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue = FieldValueHitQueue.create(sort.fields, numHits);
        if (after == null) {
            return new SimpleFieldCollector(sort, queue, numHits, fillFields, trackDocScores, trackMaxScore);
        }
        if (after.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (after.fields.length != sort.getSort().length) {
            throw new IllegalArgumentException("after.fields has " + after.fields.length + " values but sort has " + sort.getSort().length);
        }
        return new PagingFieldCollector(sort, queue, after, numHits, fillFields, trackDocScores, trackMaxScore);
    }

    final void add(int slot, int doc, float score) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(slot, this.docBase + doc, score));
        this.queueFull = this.totalHits == this.numHits;
    }

    final void updateBottom(int doc) {
        this.bottom.doc = this.docBase + doc;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    final void updateBottom(int doc, float score) {
        this.bottom.doc = this.docBase + doc;
        this.bottom.score = score;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    @Override
    protected void populateResults(ScoreDoc[] results, int howMany) {
        if (this.fillFields) {
            FieldValueHitQueue queue = (FieldValueHitQueue)this.pq;
            for (int i = howMany - 1; i >= 0; --i) {
                results[i] = queue.fillFields((FieldValueHitQueue.Entry)queue.pop());
            }
        } else {
            for (int i = howMany - 1; i >= 0; --i) {
                FieldValueHitQueue.Entry entry = (FieldValueHitQueue.Entry)this.pq.pop();
                results[i] = new FieldDoc(entry.doc, entry.score);
            }
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            results = EMPTY_SCOREDOCS;
            this.maxScore = Float.NaN;
        }
        return new TopFieldDocs(this.totalHits, results, ((FieldValueHitQueue)this.pq).getFields(), this.maxScore);
    }

    @Override
    public TopFieldDocs topDocs() {
        return (TopFieldDocs)super.topDocs();
    }

    private static final class PagingFieldCollector
    extends TopFieldCollector {
        int collectedHits;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        final boolean trackDocScores;
        final boolean trackMaxScore;
        final FieldDoc after;
        final boolean mayNeedScoresTwice;

        public PagingFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, FieldDoc after, int numHits, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) {
            super(queue, numHits, fillFields, trackDocScores || trackMaxScore || sort.needsScores());
            this.queue = queue;
            this.trackDocScores = trackDocScores;
            this.trackMaxScore = trackMaxScore;
            this.after = after;
            this.mayNeedScoresTwice = sort.needsScores() && (trackDocScores || trackMaxScore);
            this.maxScore = Float.NEGATIVE_INFINITY;
            FieldComparator<?>[] comparators = queue.comparators;
            for (int i = 0; i < comparators.length; ++i) {
                FieldComparator<?> comparator = comparators[i];
                comparator.setTopValue(after.fields[i]);
            }
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context2) throws IOException {
            this.docBase = context2.docBase;
            final int afterDoc = this.after.doc - this.docBase;
            return new MultiComparatorLeafCollector(this.queue.getComparators(context2), this.queue.getReverseMul(), this.mayNeedScoresTwice){

                @Override
                public void collect(int doc) throws IOException {
                    int cmp;
                    ++totalHits;
                    float score = Float.NaN;
                    if (trackMaxScore && (score = this.scorer.score()) > maxScore) {
                        maxScore = score;
                    }
                    if (queueFull && (cmp = this.reverseMul * this.comparator.compareBottom(doc)) <= 0) {
                        return;
                    }
                    int topCmp = this.reverseMul * this.comparator.compareTop(doc);
                    if (topCmp > 0 || topCmp == 0 && doc <= afterDoc) {
                        return;
                    }
                    if (queueFull) {
                        this.comparator.copy(bottom.slot, doc);
                        if (trackDocScores && !trackMaxScore) {
                            score = this.scorer.score();
                        }
                        this.updateBottom(doc, score);
                        this.comparator.setBottom(bottom.slot);
                    } else {
                        ++collectedHits;
                        int slot = collectedHits - 1;
                        this.comparator.copy(slot, doc);
                        if (trackDocScores && !trackMaxScore) {
                            score = this.scorer.score();
                        }
                        bottom = pq.add(new FieldValueHitQueue.Entry(slot, docBase + doc, score));
                        boolean bl = queueFull = collectedHits == numHits;
                        if (queueFull) {
                            this.comparator.setBottom(bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static class SimpleFieldCollector
    extends TopFieldCollector {
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        final boolean trackDocScores;
        final boolean trackMaxScore;
        final boolean mayNeedScoresTwice;

        public SimpleFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields, boolean trackDocScores, boolean trackMaxScore) {
            super(queue, numHits, fillFields, sort.needsScores() || trackDocScores || trackMaxScore);
            this.queue = queue;
            if (trackMaxScore) {
                this.maxScore = Float.NEGATIVE_INFINITY;
            }
            this.trackDocScores = trackDocScores;
            this.trackMaxScore = trackMaxScore;
            this.mayNeedScoresTwice = sort.needsScores() && (trackDocScores || trackMaxScore);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context2) throws IOException {
            this.docBase = context2.docBase;
            LeafFieldComparator[] comparators = this.queue.getComparators(context2);
            int[] reverseMul = this.queue.getReverseMul();
            return new MultiComparatorLeafCollector(comparators, reverseMul, this.mayNeedScoresTwice){

                @Override
                public void collect(int doc) throws IOException {
                    float score = Float.NaN;
                    if (trackMaxScore && (score = this.scorer.score()) > maxScore) {
                        maxScore = score;
                    }
                    ++totalHits;
                    if (queueFull) {
                        if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                            return;
                        }
                        if (trackDocScores && !trackMaxScore) {
                            score = this.scorer.score();
                        }
                        this.comparator.copy(bottom.slot, doc);
                        this.updateBottom(doc, score);
                        this.comparator.setBottom(bottom.slot);
                    } else {
                        int slot = totalHits - 1;
                        if (trackDocScores && !trackMaxScore) {
                            score = this.scorer.score();
                        }
                        this.comparator.copy(slot, doc);
                        this.add(slot, doc, score);
                        if (queueFull) {
                            this.comparator.setBottom(bottom.slot);
                        }
                    }
                }
            };
        }
    }

    private static abstract class MultiComparatorLeafCollector
    implements LeafCollector {
        final LeafFieldComparator comparator;
        final int reverseMul;
        final boolean mayNeedScoresTwice;
        Scorer scorer;

        MultiComparatorLeafCollector(LeafFieldComparator[] comparators, int[] reverseMul, boolean mayNeedScoresTwice) {
            if (comparators.length == 1) {
                this.reverseMul = reverseMul[0];
                this.comparator = comparators[0];
            } else {
                this.reverseMul = 1;
                this.comparator = new MultiLeafFieldComparator(comparators, reverseMul);
            }
            this.mayNeedScoresTwice = mayNeedScoresTwice;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (this.mayNeedScoresTwice && !(scorer instanceof ScoreCachingWrappingScorer)) {
                scorer = new ScoreCachingWrappingScorer(scorer);
            }
            this.comparator.setScorer(scorer);
            this.scorer = scorer;
        }
    }
}

