/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.StreamingFedoraObjectHandler;
import org.fcrepo.migration.pidlist.ResumePidListManager;
import org.fcrepo.migration.pidlist.UserProvidedPidListManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrator.class);
    private static final Timer nextTimer = Metrics.timer("fcrepo.storage.foxml.object", "operation", "findNext");
    private ObjectSource source;
    private StreamingFedoraObjectHandler handler;
    private int limit = -1;
    private ResumePidListManager resumePidListManager;
    private UserProvidedPidListManager userProvidedPidListManager;
    private boolean continueOnError;

    public static void main(String[] args) throws IOException, XMLStreamException {
        if (args.length != 1) {
            Migrator.printHelp();
            return;
        }
        FileSystemXmlApplicationContext context2 = new FileSystemXmlApplicationContext(args[0]);
        Migrator m4 = context2.getBean("migrator", Migrator.class);
        try {
            m4.run();
        }
        finally {
            context2.close();
        }
    }

    public Migrator() {
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSource(ObjectSource source) {
        this.source = source;
    }

    public void setHandler(StreamingFedoraObjectHandler handler) {
        this.handler = handler;
    }

    public void setUserProvidedPidListManager(UserProvidedPidListManager manager) {
        this.userProvidedPidListManager = manager;
    }

    public void setResumePidListManager(ResumePidListManager manager) {
        this.resumePidListManager = manager;
    }

    public void setContinueOnError(boolean flag) {
        this.continueOnError = flag;
    }

    public Migrator(ObjectSource source, StreamingFedoraObjectHandler handler) {
        this();
        this.source = source;
        this.handler = handler;
    }

    public void run() throws XMLStreamException {
        int index = 0;
        Iterator iterator = this.source.iterator();
        while (iterator.hasNext()) {
            try {
                FedoraObjectProcessor o = nextTimer.record(iterator::next);
                try {
                    String pid = o.getObjectInfo().getPid();
                    if (pid == null) continue;
                    if (this.limit < 0 || index++ < this.limit) {
                        if (this.acceptPid(pid)) {
                            LOGGER.info("Processing \"" + pid + "\"...");
                            try {
                                o.processObject(this.handler);
                            }
                            catch (Exception ex) {
                                String message = String.format("MIGRATION_FAILURE: pid=\"%s\", message=\"%s\"", pid, ex.getMessage());
                                if (this.continueOnError) {
                                    LOGGER.error(message, ex);
                                }
                                throw new RuntimeException(message, ex);
                            }
                        }
                        if (this.userProvidedPidListManager == null || !this.userProvidedPidListManager.finishedProcessingAllPids()) continue;
                        LOGGER.info("finished processing everything in pidlist - exiting.");
                        return;
                    }
                    LOGGER.info("Reached processing limit {}", (Object)this.limit);
                    break;
                }
                finally {
                    if (o == null) continue;
                    o.close();
                }
            }
            catch (Exception ex) {
                String message = String.format("MIGRATION_FAILURE: UNREADABLE_OBJECT: message=\"%s\"", ex.getMessage());
                if (this.continueOnError) {
                    LOGGER.error(message, ex);
                    continue;
                }
                throw new RuntimeException(message, ex);
            }
        }
    }

    private boolean acceptPid(String pid) {
        if (this.userProvidedPidListManager != null && !this.userProvidedPidListManager.accept(pid)) {
            return false;
        }
        return this.resumePidListManager == null || this.resumePidListManager.accept(pid);
    }

    private static void printHelp() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("============================\n");
        sb.append("Please provide the directory path to a configuration file!");
        sb.append("\n");
        sb.append("See: https://github.com/fcrepo-exts/migration-utils/blob/master/");
        sb.append("src/main/resources/spring/migration-bean.xml");
        sb.append("\n\n");
        sb.append("The configuration file should contain the following (with appropriate values):");
        sb.append("\n");
        sb.append("~~~~~~~~~~~~~~\n");
        ClassPathResource resource = new ClassPathResource("spring/migration-bean.xml");
        try (InputStream example = resource.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(example));){
            String line = reader.readLine();
            while (null != line) {
                sb.append(line);
                sb.append("\n");
                line = reader.readLine();
            }
            sb.append("~~~~~~~~~~~~~~\n\n");
            sb.append("See top of this output for details.\n");
            sb.append("============================\n");
            System.out.println(sb.toString());
        }
    }
}

