/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import edu.wisc.library.ocfl.api.DigestAlgorithmRegistry;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.File;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.jena.query.ARQ;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.Migrator;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.OcflSessionFactoryFactoryBean;
import org.fcrepo.migration.ResourceMigrationType;
import org.fcrepo.migration.foxml.AkubraFSIDResolver;
import org.fcrepo.migration.foxml.ArchiveExportedFoxmlDirectoryObjectSource;
import org.fcrepo.migration.foxml.DirectoryScanningIDResolver;
import org.fcrepo.migration.foxml.LegacyFSIDResolver;
import org.fcrepo.migration.foxml.NativeFoxmlDirectoryObjectSource;
import org.fcrepo.migration.handlers.ObjectAbstractionStreamingFedoraObjectHandler;
import org.fcrepo.migration.handlers.ocfl.ArchiveGroupHandler;
import org.fcrepo.migration.metrics.PrometheusActuator;
import org.fcrepo.migration.pidlist.ResumePidListManager;
import org.fcrepo.migration.pidlist.UserProvidedPidListManager;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="migration-utils", mixinStandardHelpOptions=true, sortOptions=false, version={"Migration Utils - 4.4.1.b"})
public class PicocliMigrator
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PicocliMigrator.class);
    private final String DEFAULT_PREFIX = "info:fedora/";
    @CommandLine.Option(names={"--source-type", "-t"}, required=true, order=1, description={"Fedora 3 source type. Choices: akubra | legacy | exported"})
    private F3SourceTypes f3SourceType;
    @CommandLine.Option(names={"--datastreams-dir", "-d"}, order=2, description={"Directory containing Fedora 3 datastreams (used with --source-type 'akubra' or 'legacy')"})
    private File f3DatastreamsDir;
    @CommandLine.Option(names={"--objects-dir", "-o"}, order=3, description={"Directory containing Fedora 3 objects (used with --source-type 'akubra' or 'legacy')"})
    private File f3ObjectsDir;
    @CommandLine.Option(names={"--exported-dir", "-e"}, order=4, description={"Directory containing Fedora 3 export (used with --source-type 'exported')"})
    private File f3ExportedDir;
    @CommandLine.Option(names={"--target-dir", "-a"}, required=true, order=5, description={"OCFL storage root directory (data/ocfl-root is created for migration-type FEDORA_OCFL)"})
    private File targetDir;
    @CommandLine.Option(names={"--working-dir", "-i"}, order=6, description={"Directory where supporting state will be written (cached index of datastreams, ...)"})
    private File workingDir;
    @CommandLine.Option(names={"--delete-inactive", "-I"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=18, description={"Migrate objects and datastreams in the Inactive state as deleted. Default: false."})
    private boolean deleteInactive;
    @CommandLine.Option(names={"--atomic-resources", "-A"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=19, description={"Migrate objects and datastreams as atomic resources instead of archival groups"})
    private boolean atomicResources;
    @CommandLine.Option(names={"--migration-type", "-m"}, defaultValue="FEDORA_OCFL", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=20, description={"Type of OCFL objects to migrate to. Choices: FEDORA_OCFL | PLAIN_OCFL"})
    private MigrationType migrationType;
    @CommandLine.Option(names={"--id-prefix"}, defaultValue="info:fedora/", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=21, description={"Only use this for PLAIN_OCFL migrations: Prefix to add to PIDs for OCFL object IDs - defaults to info:fedora/, like Fedora3"})
    private String idPrefix;
    @CommandLine.Option(names={"--foxml-file"}, defaultValue="false", order=22, description={"Migrate FOXML file as a whole file, instead of creating property files. FOXML file will be migrated, then marked as deleted so it doesn't show up as an active file."})
    private boolean foxmlFile;
    @CommandLine.Option(names={"--limit", "-l"}, defaultValue="-1", order=23, description={"Limit number of objects to be processed.\n  Default: no limit"})
    private int objectLimit;
    @CommandLine.Option(names={"--resume", "-r"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=24, description={"Resume from last successfully migrated Fedora 3 object"})
    private boolean resume;
    @CommandLine.Option(names={"--continue-on-error", "-c"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=25, description={"Continue to next PID if an error occurs (instead of exiting). Disabled by default."})
    private boolean continueOnError;
    @CommandLine.Option(names={"--pid-file", "-p"}, order=26, description={"PID file listing which Fedora 3 objects to migrate"})
    private File pidFile;
    @CommandLine.Option(names={"--extensions", "-x"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=27, description={"Add file extensions to migrated datastreams based on mimetype recorded in FOXML"})
    private boolean addExtensions;
    @CommandLine.Option(names={"--f3hostname", "-f"}, defaultValue="fedora.info", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=28, description={"Hostname of Fedora 3, used for replacing placeholder in 'E' and 'R' datastream URLs"})
    private String f3hostname;
    @CommandLine.Option(names={"--username", "-u"}, defaultValue="fedoraAdmin", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=29, description={"The username to associate with all of the migrated resources."})
    private String user;
    @CommandLine.Option(names={"--user-uri", "-U"}, defaultValue="info:fedora/fedoraAdmin", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=30, description={"The username to associate with all of the migrated resources."})
    private String userUri;
    @CommandLine.Option(names={"--algorithm"}, defaultValue="sha512", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=31, description={"The digest algorithm to use in the OCFL objects created. Either sha256 or sha512"})
    private String digestAlgorithm;
    @CommandLine.Option(names={"--no-checksum-validation"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=32, description={"Disable validation that datastream content matches Fedora 3 checksum."})
    private boolean disableChecksumValidation;
    @CommandLine.Option(names={"--enable-metrics"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=33, description={"Enable gathering of metrics for a Prometheus instance. \nNote: this requires port 8080 to be free in order for Prometheus to scrape metrics."})
    private boolean enableMetrics;
    @CommandLine.Option(names={"--disable-dc"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=36, description={"Disable migrating DC datastream into RDF object properties. "})
    private boolean disableDc;
    @CommandLine.Option(names={"--head-only", "-H"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=35, description={"Migrate only the HEAD of each datastream"})
    private boolean headOnly;
    @CommandLine.Option(names={"--debug"}, order=34, description={"Enables debug logging"})
    private boolean debug;
    private File indexDir;
    private File ocflStorageDir;

    public static void main(String[] args) {
        PicocliMigrator migrator = new PicocliMigrator();
        CommandLine cmd = new CommandLine(migrator);
        cmd.registerConverter(F3SourceTypes.class, F3SourceTypes::toType);
        cmd.setExecutionExceptionHandler(new PicoliMigrationExceptionHandler(migrator));
        cmd.execute(args);
    }

    private static void setDebugLogLevel() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger("org.fcrepo.migration");
        logger.setLevel(Level.toLevel("DEBUG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        ObjectSource objectSource;
        File pidDir;
        File ocflStagingDir;
        if (this.debug) {
            PicocliMigrator.setDebugLogLevel();
        }
        if (this.migrationType == MigrationType.FEDORA_OCFL && !this.idPrefix.equals("info:fedora/")) {
            throw new IllegalArgumentException("Can't change the ID Prefix for FEDORA_OCFL migrations");
        }
        if (!this.digestAlgorithm.equals("sha512") && !this.digestAlgorithm.equalsIgnoreCase("sha256")) {
            throw new IllegalArgumentException("Invalid algorithm specified, must be one of sha512 or sha256");
        }
        if (this.headOnly && this.atomicResources) {
            throw new IllegalArgumentException("Atomic migrations currently do not support the head only option");
        }
        DigestAlgorithm algorithm = DigestAlgorithmRegistry.getAlgorithm(this.digestAlgorithm);
        Enforce.notNull(algorithm, "Invalid algorithm specified, must be one of sha512 or sha256");
        Enforce.notNull(this.targetDir, "targetDir must be provided!");
        if (!this.targetDir.exists()) {
            this.targetDir.mkdirs();
        }
        if (this.workingDir == null) {
            LOGGER.info("No working-dir option passed in - using current directory.");
            this.workingDir = new File(System.getProperty("user.dir"));
        }
        if (!this.workingDir.exists()) {
            this.workingDir.mkdirs();
        }
        this.indexDir = new File(this.workingDir, "index");
        if (this.migrationType == MigrationType.FEDORA_OCFL) {
            this.ocflStorageDir = this.targetDir.toPath().resolve("data").resolve("ocfl-root").toFile();
            if (!this.ocflStorageDir.exists()) {
                this.ocflStorageDir.mkdirs();
            }
        } else {
            this.ocflStorageDir = this.targetDir;
        }
        if (!(ocflStagingDir = new File(this.workingDir, "staging")).exists()) {
            ocflStagingDir.mkdirs();
        }
        if (!(pidDir = new File(this.workingDir, "pid")).exists()) {
            pidDir.mkdirs();
        }
        DirectoryScanningIDResolver idResolver = null;
        switch (this.f3SourceType) {
            case EXPORTED: {
                Enforce.notNull(this.f3ExportedDir, "f3ExportDir must be used with 'exported' source!");
                objectSource = new ArchiveExportedFoxmlDirectoryObjectSource(this.f3ExportedDir, this.f3hostname);
                break;
            }
            case AKUBRA: {
                Enforce.notNull(this.f3DatastreamsDir, "f3DatastreamsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.notNull(this.f3ObjectsDir, "f3ObjectsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.expressionTrue(this.f3ObjectsDir.exists(), this.f3ObjectsDir, "f3ObjectsDir must exist! " + this.f3ObjectsDir.getAbsolutePath());
                idResolver = new AkubraFSIDResolver(this.indexDir, this.f3DatastreamsDir);
                objectSource = new NativeFoxmlDirectoryObjectSource(this.f3ObjectsDir, idResolver, this.f3hostname);
                break;
            }
            case LEGACY: {
                Enforce.notNull(this.f3DatastreamsDir, "f3DatastreamsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.notNull(this.f3ObjectsDir, "f3ObjectsDir must be used with 'akubra' or 'legacy' source!");
                Enforce.expressionTrue(this.f3ObjectsDir.exists(), this.f3ObjectsDir, "f3ObjectsDir must exist! " + this.f3ObjectsDir.getAbsolutePath());
                idResolver = new LegacyFSIDResolver(this.indexDir, this.f3DatastreamsDir);
                objectSource = new NativeFoxmlDirectoryObjectSource(this.f3ObjectsDir, idResolver, this.f3hostname);
                break;
            }
            default: {
                throw new RuntimeException("Should never happen");
            }
        }
        PrometheusActuator actuator = new PrometheusActuator(this.enableMetrics);
        actuator.start();
        OcflObjectSessionFactory ocflSessionFactory = new OcflSessionFactoryFactoryBean(this.ocflStorageDir.toPath(), ocflStagingDir.toPath(), this.migrationType, this.user, this.userUri, algorithm, this.disableChecksumValidation).getObject();
        ArchiveGroupHandler archiveGroupHandler = new ArchiveGroupHandler(ocflSessionFactory, this.migrationType, this.atomicResources ? ResourceMigrationType.ATOMIC : ResourceMigrationType.ARCHIVAL, this.addExtensions, this.deleteInactive, this.foxmlFile, this.user, this.idPrefix, this.headOnly, this.disableChecksumValidation, this.disableDc);
        ObjectAbstractionStreamingFedoraObjectHandler objectHandler = new ObjectAbstractionStreamingFedoraObjectHandler(archiveGroupHandler);
        ResumePidListManager resumeManager = new ResumePidListManager(pidDir, !this.resume);
        UserProvidedPidListManager pidListManager = new UserProvidedPidListManager(this.pidFile);
        Migrator migrator = new Migrator();
        migrator.setLimit(this.objectLimit);
        migrator.setSource(objectSource);
        migrator.setHandler(objectHandler);
        migrator.setResumePidListManager(resumeManager);
        migrator.setUserProvidedPidListManager(pidListManager);
        migrator.setContinueOnError(this.continueOnError);
        ARQ.init();
        try {
            migrator.run();
        }
        finally {
            ocflSessionFactory.close();
            if (idResolver != null) {
                idResolver.close();
            }
            FileUtils.deleteDirectory(ocflStagingDir);
            actuator.stop();
        }
        return 0;
    }

    private static class PicoliMigrationExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private final PicocliMigrator migrator;

        PicoliMigrationExceptionHandler(PicocliMigrator migrator) {
            this.migrator = migrator;
        }

        @Override
        public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            commandLine.getErr().println(ex.getMessage());
            if (this.migrator.debug) {
                ex.printStackTrace(commandLine.getErr());
            }
            commandLine.usage(commandLine.getErr());
            return commandLine.getCommandSpec().exitCodeOnExecutionException();
        }
    }

    private static enum F3SourceTypes {
        AKUBRA,
        LEGACY,
        EXPORTED;


        static F3SourceTypes toType(String v) {
            return F3SourceTypes.valueOf(v.toUpperCase());
        }
    }
}

