/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import edu.wisc.library.ocfl.api.MutableOcflRepository;
import java.nio.file.Path;
import java.util.UUID;
import org.fcrepo.migration.handlers.ocfl.PlainOcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainOcflObjectSessionFactory
implements OcflObjectSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlainOcflObjectSessionFactory.class);
    private final MutableOcflRepository ocflRepo;
    private final Path stagingRoot;
    private final String defaultVersionMessage;
    private final String defaultVersionUserName;
    private final String defaultVersionUserAddress;
    private final boolean disableChecksumValidation;
    private boolean closed = false;

    public PlainOcflObjectSessionFactory(MutableOcflRepository ocflRepo, Path stagingRoot, String defaultVersionMessage, String defaultVersionUserName, String defaultVersionUserAddress, boolean disableChecksumValidation) {
        this.ocflRepo = ocflRepo;
        this.stagingRoot = stagingRoot;
        this.defaultVersionMessage = defaultVersionMessage;
        this.defaultVersionUserName = defaultVersionUserName;
        this.defaultVersionUserAddress = defaultVersionUserAddress;
        this.disableChecksumValidation = disableChecksumValidation;
    }

    @Override
    public OcflObjectSession newSession(String ocflObjectId) {
        this.enforceOpen();
        String sessionId = UUID.randomUUID().toString();
        PlainOcflObjectSession session = new PlainOcflObjectSession(sessionId, this.ocflRepo, ocflObjectId, this.stagingRoot.resolve(sessionId), this.disableChecksumValidation);
        session.versionAuthor(this.defaultVersionUserName, this.defaultVersionUserAddress);
        session.versionMessage(this.defaultVersionMessage);
        return session;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.ocflRepo.close();
        }
    }

    @Override
    public void useUnsafeWrite(boolean useUnsafeWrite) {
    }

    private void enforceOpen() {
        if (this.closed) {
            throw new IllegalStateException("The session factory is closed!");
        }
    }
}

