/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.util.List;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.proxy.CallbackGenerator;

class FixedValueGenerator
implements CallbackGenerator {
    public static final FixedValueGenerator INSTANCE = new FixedValueGenerator();
    private static final Type FIXED_VALUE = TypeUtils.parseType("org.springframework.cglib.proxy.FixedValue");
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");

    FixedValueGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context2, List methods) {
        for (MethodInfo method : methods) {
            CodeEmitter e2 = context2.beginMethod(ce, method);
            context2.emitCallback(e2, context2.getIndex(method));
            e2.invoke_interface(FIXED_VALUE, LOAD_OBJECT);
            e2.unbox_or_zero(e2.getReturnType());
            e2.return_value();
            e2.end_method();
        }
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context2, List methods) {
    }
}

