/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree.
 *
 */
package org.fcrepo.migration.foxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * A CachedContent implementation that exposes content stored
 * at a resolvable URL.
 * @author mdurbin
 */
public class URLCachedContent implements CachedContent {

    private URL url;

    private URLFetcher fetcher;

    /**
     * url cached content.
     * @param url the url
     * @param fetcher the fetcher
     */
    public URLCachedContent(final URL url, final URLFetcher fetcher) {
        this.fetcher = fetcher;
        this.url = url;
    }
    /**
     * get URL.
     * @return the url
     */
    public URL getURL() {
        return url;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return fetcher.getContentAtUrl(url);
    }
}
