/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.foxml;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectSource;
import org.fcrepo.migration.foxml.FoxmlDirectoryDFSIterator;
import org.fcrepo.migration.foxml.HttpClientURLFetcher;
import org.fcrepo.migration.foxml.InternalIDResolver;
import org.fcrepo.migration.foxml.URLFetcher;

public class NativeFoxmlDirectoryObjectSource
implements ObjectSource {
    private InternalIDResolver resolver;
    private URLFetcher fetcher;
    private File root;
    private String localFedoraServer;
    private FileFilter fileFilter = new RegexFileFilter(Pattern.compile("^[^\\.].*$"));

    public NativeFoxmlDirectoryObjectSource(File objectStore, InternalIDResolver resolver, String localFedoraServer) {
        this.root = objectStore;
        this.resolver = resolver;
        this.fetcher = new HttpClientURLFetcher();
        this.localFedoraServer = localFedoraServer;
    }

    public void setFetcher(URLFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public Iterator<FedoraObjectProcessor> iterator() {
        return new FoxmlDirectoryDFSIterator(this.root, this.resolver, this.fetcher, this.localFedoraServer, this.fileFilter);
    }
}

