/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.foxml;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.stax2.XMLInputFactory2;
import org.fcrepo.migration.ContentDigest;
import org.fcrepo.migration.DatastreamInfo;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.DefaultContentDigest;
import org.fcrepo.migration.DefaultObjectInfo;
import org.fcrepo.migration.FedoraObjectProcessor;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.StreamingFedoraObjectHandler;
import org.fcrepo.migration.foxml.CachedContent;
import org.fcrepo.migration.foxml.FileCachedContent;
import org.fcrepo.migration.foxml.FoxmlObjectProperties;
import org.fcrepo.migration.foxml.InternalIDResolver;
import org.fcrepo.migration.foxml.MemoryCachedContent;
import org.fcrepo.migration.foxml.URLCachedContent;
import org.fcrepo.migration.foxml.URLFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FoxmlInputStreamFedoraObjectProcessor
implements FedoraObjectProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FoxmlInputStreamFedoraObjectProcessor.class);
    private static final Pattern INLINE_PATTERN = Pattern.compile("<foxml:xmlContent>(.*?)</foxml:xmlContent>", 32);
    private static final String FOXML_NS = "info:fedora/fedora-system:def/foxml#";
    private static final String METRIC_NAME = "fcrepo.storage.foxml.object";
    private static final String OPERATION = "operation";
    private static final Timer processObjectTimer = Metrics.timer((String)"fcrepo.storage.foxml.object", (String[])new String[]{"operation", "processObject"});
    private static final Timer completeObjectTimer = Metrics.timer((String)"fcrepo.storage.foxml.object", (String[])new String[]{"operation", "completeObject"});
    private URLFetcher fetcher;
    private String localFedoraServer;
    private InternalIDResolver idResolver;
    private File file;
    private InputStream stream;
    private XMLStreamReader reader;
    private DocumentBuilder documentBuilder;
    private List<File> tempFiles;
    private LinkedList<String> inlineXml;
    private ObjectInfo objectInfo;

    public FoxmlInputStreamFedoraObjectProcessor(File file, URLFetcher fetcher, InternalIDResolver resolver, String localFedoraServer) throws XMLStreamException, FileNotFoundException {
        this.file = file;
        this.fetcher = fetcher;
        this.idResolver = resolver;
        this.localFedoraServer = localFedoraServer;
        XMLInputFactory factory = XMLInputFactory.newFactory();
        this.stream = new BufferedInputStream(new FileInputStream(file));
        this.reader = factory.createXMLStreamReader(this.stream);
        this.reader.nextTag();
        Map<String, String> attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(this.reader, "PID", "VERSION", "FEDORA_URI", "schemaLocation");
        this.objectInfo = new DefaultObjectInfo(attributes.get("PID"), attributes.get("FEDORA_URI"), this.file.toPath());
        while (this.reader.next() == 4) {
        }
        this.tempFiles = new ArrayList<File>();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        builderFactory.setIgnoringComments(false);
        try {
            this.documentBuilder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            this.inlineXml = new LinkedList();
            String content = FileUtils.readFileToString((File)file);
            Matcher matcher = INLINE_PATTERN.matcher(content);
            while (matcher.find()) {
                this.inlineXml.add(matcher.group(1));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processObject(StreamingFedoraObjectHandler handler) {
        Timer.Sample stopwatch = Timer.start();
        handler.beginObject(this.objectInfo);
        Foxml11DatastreamInfo dsInfo = null;
        try {
            handler.processObjectProperties(this.readProperties());
            while (this.reader.hasNext()) {
                if (this.reader.isCharacters()) {
                    if (!this.reader.isWhiteSpace()) {
                        throw new RuntimeException("Unexpected character data! \"" + this.reader.getText() + "\"");
                    }
                } else if (this.reader.isStartElement()) {
                    if (this.reader.getLocalName().equals("datastream") && this.reader.getNamespaceURI().equals(FOXML_NS)) {
                        dsInfo = new Foxml11DatastreamInfo(this.objectInfo, this.reader);
                    } else {
                        if (!this.reader.getLocalName().equals("datastreamVersion")) throw new RuntimeException("Unexpected element! \"" + this.reader.getLocalName() + "\"!");
                        Foxml11DatastreamVersion v = new Foxml11DatastreamVersion(dsInfo, this.reader);
                        try {
                            v.validateInlineXml();
                        }
                        catch (RuntimeException e) {
                            LOG.error("Inline Validation failed", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        handler.processDatastreamVersion(v);
                    }
                } else if (this.reader.isEndElement() && dsInfo != null && this.reader.getLocalName().equals("datastream")) {
                    dsInfo = null;
                } else if (!this.reader.isEndElement() || !this.reader.getLocalName().equals("digitalObject")) {
                    throw new RuntimeException("Unexpected xml structure! \"" + this.reader.getEventType() + "\" at line " + this.reader.getLocation().getLineNumber() + ", column " + this.reader.getLocation().getColumnNumber() + "!" + (String)(this.reader.isCharacters() ? "  \"" + this.reader.getText() + "\"" : ""));
                }
                this.reader.next();
            }
        }
        catch (Exception e) {
            this.abort(handler, e);
        }
        finally {
            stopwatch.stop(processObjectTimer);
        }
        completeObjectTimer.record(() -> this.complete(handler));
    }

    private void complete(StreamingFedoraObjectHandler handler) {
        try {
            handler.completeObject(this.objectInfo);
            this.cleanUpTempFiles();
        }
        catch (Exception e) {
            this.abort(handler, e);
        }
    }

    private void abort(StreamingFedoraObjectHandler handler, Exception e) {
        try {
            handler.abortObject(this.objectInfo);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        catch (Throwable throwable) {
            this.cleanUpTempFiles();
            this.close();
            throw throwable;
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            LOG.warn("Failed to close reader cleanly", (Throwable)e);
        }
        try {
            this.stream.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close file cleanly", (Throwable)e);
        }
    }

    private void cleanUpTempFiles() {
        for (File f : this.tempFiles) {
            if (!f.exists()) continue;
            f.delete();
        }
    }

    private ObjectProperties readProperties() throws JAXBException, XMLStreamException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FoxmlObjectProperties.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement p = unmarshaller.unmarshal(this.reader, FoxmlObjectProperties.class);
        FoxmlObjectProperties properties = (FoxmlObjectProperties)p.getValue();
        return properties;
    }

    private void readUntilClosed(String name, String namespace) throws XMLStreamException {
        while (this.reader.hasNext()) {
            if (this.reader.isEndElement() && this.reader.getLocalName().equals(name) && this.reader.getNamespaceURI().equals(namespace)) {
                return;
            }
            this.reader.next();
        }
    }

    private static Map<String, String> getAttributes(XMLStreamReader r, String ... allowedNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> allowed = new HashSet<String>(Arrays.asList(allowedNames));
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String localName = r.getAttributeLocalName(i);
            String value = r.getAttributeValue(i);
            if (allowed.contains(localName)) {
                result.put(localName, value);
                continue;
            }
            System.err.println("Unexpected attribute: " + localName + " = \"" + value + "\"");
        }
        return result;
    }

    public class Foxml11DatastreamVersion
    implements DatastreamVersion {
        private DatastreamInfo dsInfo;
        private String id;
        private String label;
        private String created;
        private Instant createdInstant;
        private String mimeType;
        private String altIds;
        private String formatUri;
        private long size;
        private ContentDigest contentDigest;
        private CachedContent dsContent;
        private boolean isInlineXml = false;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Foxml11DatastreamVersion(DatastreamInfo dsInfo, XMLStreamReader reader) throws XMLStreamException {
            this.dsInfo = dsInfo;
            Map<String, String> dsAttributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "ID", "LABEL", "CREATED", "MIMETYPE", "ALT_IDS", "FORMAT_URI", "SIZE");
            this.id = dsAttributes.get("ID");
            this.label = dsAttributes.get("LABEL");
            this.created = dsAttributes.get("CREATED");
            this.createdInstant = this.created != null ? Instant.parse(this.created) : null;
            this.mimeType = dsAttributes.get("MIMETYPE");
            this.altIds = dsAttributes.get("ALT_IDS");
            this.formatUri = dsAttributes.get("FORMAT_URI");
            this.size = dsAttributes.containsKey("SIZE") ? Long.parseLong(dsAttributes.get("SIZE")) : -1L;
            reader.next();
            while (reader.hasNext()) {
                if (reader.isCharacters()) {
                    if (!reader.isWhiteSpace()) {
                        throw new RuntimeException("Unexpected character data! \"" + reader.getText() + "\"");
                    }
                } else if (reader.isStartElement()) {
                    Map<String, String> attributes;
                    String localName = reader.getLocalName();
                    if (localName.equals("contentDigest")) {
                        attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "TYPE", "DIGEST");
                        this.contentDigest = new DefaultContentDigest(attributes.get("TYPE"), attributes.get("DIGEST"));
                    } else if (localName.equals("xmlContent")) {
                        reader.next();
                        this.isInlineXml = true;
                        this.dsContent = new MemoryCachedContent(this.extractInlineXml());
                    } else if (localName.equals("contentLocation")) {
                        attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "REF", "TYPE");
                        if (attributes.get("TYPE").equals("INTERNAL_ID")) {
                            this.dsContent = FoxmlInputStreamFedoraObjectProcessor.this.idResolver.resolveInternalID(attributes.get("REF"));
                        } else {
                            try {
                                String ref = attributes.get("REF");
                                if (ref.contains("local.fedora.server")) {
                                    ref = ref.replace("local.fedora.server", FoxmlInputStreamFedoraObjectProcessor.this.localFedoraServer);
                                }
                                this.dsContent = new URLCachedContent(new URL(ref), FoxmlInputStreamFedoraObjectProcessor.this.fetcher);
                            }
                            catch (MalformedURLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    } else {
                        if (!localName.equals("binaryContent")) throw new RuntimeException("Unexpected element! \"" + reader.getLocalName() + "\"!");
                        try {
                            File f = File.createTempFile("decoded", "file");
                            FoxmlInputStreamFedoraObjectProcessor.this.tempFiles.add(f);
                            Base64OutputStream out = new Base64OutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(f)), false);
                            while (reader.next() == 4) {
                                out.write(reader.getText().getBytes("UTF-8"));
                            }
                            out.flush();
                            out.close();
                            this.dsContent = new FileCachedContent(f);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        FoxmlInputStreamFedoraObjectProcessor.this.readUntilClosed("binaryContent", FoxmlInputStreamFedoraObjectProcessor.FOXML_NS);
                    }
                } else {
                    if (!reader.isEndElement()) throw new RuntimeException("Unexpected xml structure! \"" + reader.getEventType() + "\" at line " + reader.getLocation().getLineNumber() + ", column " + reader.getLocation().getColumnNumber() + "!" + (String)(reader.isCharacters() ? "  \"" + reader.getText() + "\"" : ""));
                    if (reader.getLocalName().equals("datastreamVersion")) {
                        return;
                    }
                }
                reader.next();
            }
        }

        @Override
        public Optional<File> getFile() {
            return this.dsContent.getFile();
        }

        private String extractInlineXml() throws XMLStreamException {
            XMLEvent event;
            XMLEventReader eventReader = XMLInputFactory2.newFactory().createXMLEventReader(FoxmlInputStreamFedoraObjectProcessor.this.reader);
            while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && event.asEndElement().getName().getLocalPart().equals("xmlContent") && event.asEndElement().getName().getNamespaceURI().equals(FoxmlInputStreamFedoraObjectProcessor.FOXML_NS))) {
            }
            return FoxmlInputStreamFedoraObjectProcessor.this.inlineXml.removeFirst();
        }

        private void validateInlineXml() {
            if (this.isInlineXml && this.contentDigest != null && StringUtils.isNotBlank((CharSequence)this.contentDigest.getDigest())) {
                if (StringUtils.equals((CharSequence)this.contentDigest.getType(), (CharSequence)"DISABLED")) {
                    LOG.warn("Datastream Digest DISABLED. Skipping digest validation");
                    return;
                }
                byte[] transformedXml = this.transformInlineXmlForChecksum();
                MessageDigest digest = DigestUtils.getDigest((String)this.contentDigest.getType());
                byte[] digestBytes = DigestUtils.digest((MessageDigest)digest, (byte[])transformedXml);
                String digestHex = Hex.encodeHexString((byte[])digestBytes);
                if (!digestHex.equalsIgnoreCase(this.contentDigest.getDigest())) {
                    throw new RuntimeException(String.format("Inline XML %s %s failed checksum validation. Expected %s: %s; Actual: %s", this.dsInfo.getObjectInfo().getPid(), this.dsInfo.getDatastreamId(), this.contentDigest.getType(), this.contentDigest.getDigest(), digestHex));
                }
            }
        }

        private byte[] transformInlineXmlForChecksum() {
            try {
                String line;
                String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + IOUtils.toString((InputStream)this.dsContent.getInputStream(), (Charset)StandardCharsets.UTF_8);
                InputStreamReader isReader = new InputStreamReader(IOUtils.toInputStream((String)xml), StandardCharsets.UTF_8);
                InputSource source = new InputSource(isReader);
                source.setEncoding("UTF-8");
                Document doc = FoxmlInputStreamFedoraObjectProcessor.this.documentBuilder.parse(source);
                OutputFormat fmt = new OutputFormat("XML", "UTF-8", false);
                fmt.setIndent(0);
                fmt.setLineWidth(0);
                fmt.setPreserveSpace(false);
                StringWriter out = new StringWriter();
                XMLSerializer ser = new XMLSerializer((Writer)out, fmt);
                ser.serialize(doc);
                out.close();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedReader br = new BufferedReader(new StringReader(out.toString()));
                PrintWriter outStream = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    outStream.append(line);
                }
                outStream.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (SAXException e) {
                try {
                    LOG.error("Malformed inline XML: {}", (Object)IOUtils.toString((InputStream)this.dsContent.getInputStream()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public DatastreamInfo getDatastreamInfo() {
            return this.dsInfo;
        }

        @Override
        public String getVersionId() {
            return this.id;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getCreated() {
            return this.created;
        }

        @Override
        public Instant getCreatedInstant() {
            return this.createdInstant;
        }

        @Override
        public String getAltIds() {
            return this.altIds;
        }

        @Override
        public String getFormatUri() {
            return this.formatUri;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public ContentDigest getContentDigest() {
            if (this.isInlineXml) {
                return null;
            }
            return this.contentDigest;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.dsContent.getInputStream();
        }

        @Override
        public String getExternalOrRedirectURL() {
            if (this.dsContent instanceof URLCachedContent) {
                return ((URLCachedContent)this.dsContent).getURL().toString();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean isFirstVersionIn(ObjectReference obj) {
            List<DatastreamVersion> datastreams = obj.getDatastreamVersions(this.getDatastreamInfo().getDatastreamId());
            return datastreams.indexOf(this) == 0;
        }

        @Override
        public boolean isLastVersionIn(ObjectReference obj) {
            List<DatastreamVersion> datastreams = obj.getDatastreamVersions(this.getDatastreamInfo().getDatastreamId());
            return datastreams.indexOf(this) == datastreams.size() - 1;
        }
    }

    private class Foxml11DatastreamInfo
    implements DatastreamInfo {
        private String id;
        private String controlGroup;
        private String fedoraUri;
        private String state;
        private boolean versionable;
        private ObjectInfo objectInfo;

        public Foxml11DatastreamInfo(ObjectInfo objectInfo, XMLStreamReader reader) {
            this.objectInfo = objectInfo;
            Map<String, String> attributes = FoxmlInputStreamFedoraObjectProcessor.getAttributes(reader, "ID", "CONTROL_GROUP", "FEDORA_URI", "STATE", "VERSIONABLE");
            this.id = attributes.get("ID");
            this.controlGroup = attributes.get("CONTROL_GROUP");
            this.fedoraUri = attributes.get("FEDORA_URI");
            this.state = attributes.get("STATE");
            this.versionable = Boolean.valueOf(attributes.get("VERSIONABLE"));
        }

        @Override
        public ObjectInfo getObjectInfo() {
            return this.objectInfo;
        }

        @Override
        public String getDatastreamId() {
            return this.id;
        }

        @Override
        public String getControlGroup() {
            return this.controlGroup;
        }

        @Override
        public String getFedoraURI() {
            return this.fedoraUri;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public boolean getVersionable() {
            return this.versionable;
        }
    }
}

