/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.ImmutableMapEntry;
import org.modeshape.common.collection.Multimap;

public abstract class AbstractMultimapTest {
    protected Multimap<String, String> multimap;
    protected String[] keys;
    protected String[] values;

    @Before
    public void beforeEach() {
        this.multimap = this.createMultimap();
        this.keys = new String[]{"key1", "key2", "key3", "key4"};
        this.values = new String[]{"value1", "value2", "value3", "value4", "value5", "value6"};
    }

    @After
    public void afterEach() {
        this.multimap = null;
    }

    protected abstract <K, V> Multimap<K, V> createMultimap();

    protected abstract boolean valuesAllowDuplicates();

    @Test
    public void shouldBeEmptyAfterCreation() {
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveZeroSizeAfterCreation() {
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldNotBeEmptyAfterAddingKeyValuePairToEmptyCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)1));
        this.assertKeys((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[0]);
        this.assertValues((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[0], (V)this.values[0]);
        this.assertEntries((Multimap<K, V>)((Multimap)this.multimap), (Map.Entry<K, V>)this.entry(this.keys[0], this.values[0]));
    }

    @Test
    public void shouldNotBeEmptyAfterAddingKeyAndTwoValuesToEmptyCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)2));
        this.assertKeys((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[0]);
        this.assertValues((Multimap)this.multimap, (Object)this.keys[0], (V[])new String[]{this.values[0], this.values[1]});
        this.assertEntries(this.multimap, this.entry(this.keys[0], this.values[0]), this.entry(this.keys[0], this.values[1]));
    }

    @Test
    public void shouldNotBeEmptyAfterAddingMultipleKeyValuePairsToEmptyCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)2));
        this.assertKeys((Multimap)this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[0], (V)this.values[0]);
        this.assertValues((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[1], (V)this.values[1]);
        this.assertEntries(this.multimap, this.entry(this.keys[0], this.values[0]), this.entry(this.keys[1], this.values[1]));
    }

    @Test
    public void shouldNotBeEmptyAfterAddingMultipleKeyValuePairsMultipleTimesToEmptyCollection() {
        for (int i = 0; i != 3; ++i) {
            this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
            this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        }
        if (this.valuesAllowDuplicates()) {
            Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)6));
            this.assertKeys((Multimap)this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
            this.assertValues((Multimap)this.multimap, (Object)this.keys[0], (V[])new String[]{this.values[0], this.values[0], this.values[0]});
            this.assertValues((Multimap)this.multimap, (Object)this.keys[1], (V[])new String[]{this.values[1], this.values[1], this.values[1]});
            ArrayList entries = new ArrayList();
            for (int i = 0; i != 3; ++i) {
                entries.add(this.entry(this.keys[0], this.values[0]));
                entries.add(this.entry(this.keys[1], this.values[1]));
            }
            this.assertEntries(this.multimap, entries);
        } else {
            Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)2));
            this.assertKeys((Multimap)this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
            this.assertValues((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[0], (V)this.values[0]);
            this.assertValues((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[1], (V)this.values[1]);
            this.assertEntries(this.multimap, this.entry(this.keys[0], this.values[0]), this.entry(this.keys[1], this.values[1]));
        }
    }

    @Test
    public void shouldAllowAddingToCollectionOfValues() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection vals = this.multimap.get((Object)this.keys[0]);
        vals.add(this.values[1]);
        vals.add(this.values[2]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)3));
        this.assertKeys((Multimap<K, V>)((Multimap)this.multimap), (K)this.keys[0]);
        this.assertValues((Multimap)this.multimap, (Object)this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertEntries(this.multimap, this.entry(this.keys[0], this.values[0]), this.entry(this.keys[0], this.values[1]), this.entry(this.keys[0], this.values[2]));
    }

    @Test
    @FixFor(value={"MODE-2743"})
    public void shouldDecrementSizeOnValueIteratorRemove() {
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Assert.assertEquals((long)1L, (long)this.multimap.size());
        Iterator iterator = this.multimap.get((Object)this.keys[0]).iterator();
        iterator.next();
        iterator.remove();
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
    }

    @Test
    public void shouldIterateSuccessfullyWithRemoval() {
        for (String v : this.values) {
            this.multimap.put((Object)this.keys[0], (Object)v);
        }
        Iterator iter = this.multimap.get((Object)this.keys[0]).iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        Assert.assertTrue((boolean)this.multimap.isEmpty());
    }

    @Test
    public void shouldSuccessfullyRemoveLastElementFromValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertTrue((boolean)collection.contains(this.values[0]));
        Assert.assertTrue((boolean)collection.remove(this.values[0]));
        Assert.assertFalse((boolean)collection.contains(this.values[0]));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        Assert.assertFalse((boolean)collection.remove(this.values[0]));
        Assert.assertFalse((boolean)collection.contains(this.values[0]));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyAddValueToValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)1L, (long)this.multimap.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
        Assert.assertTrue((boolean)collection.add(this.values[1]));
        Assert.assertEquals((long)2L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)2L, (long)this.multimap.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
    }

    @Test
    public void shouldSuccessfullyAddValueToEmptyValueCollection() {
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertTrue((boolean)collection.add(this.values[0]));
        Assert.assertTrue((boolean)collection.contains(this.values[0]));
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)1L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyAddValueToEmptiedValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertTrue((boolean)collection.remove(this.values[0]));
        Assert.assertFalse((boolean)collection.contains(this.values[0]));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        Assert.assertTrue((boolean)collection.add(this.values[0]));
        Assert.assertTrue((boolean)collection.contains(this.values[0]));
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)1L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyRemoveAllFromValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertTrue((boolean)collection.removeAll(Arrays.asList(this.values)));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        Assert.assertFalse((boolean)collection.removeAll(Arrays.asList(this.values)));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyAddAllToValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        collection.addAll(Arrays.asList(this.values));
        int expectedNumberOfValues = this.values.length;
        if (this.valuesAllowDuplicates()) {
            ++expectedNumberOfValues;
        }
        Assert.assertEquals((long)expectedNumberOfValues, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)expectedNumberOfValues, (long)this.multimap.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
    }

    @Test
    public void shouldSuccessfullyClearValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        collection.clear();
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        collection.clear();
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyAddAllToEmptyValueCollection() {
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertTrue((boolean)collection.addAll(Arrays.asList(this.values)));
        Assert.assertEquals((long)this.values.length, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)this.values.length, (long)this.multimap.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
    }

    @Test
    public void shouldSuccessfullyAddAllToEmptiedValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        collection.clear();
        Assert.assertTrue((boolean)collection.addAll(Arrays.asList(this.values)));
        Assert.assertEquals((long)this.values.length, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)this.values.length, (long)this.multimap.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
    }

    @Test
    public void shouldRetainAllInValueCollection() {
        for (String value : this.values) {
            this.multimap.put((Object)this.keys[0], (Object)value);
        }
        Assert.assertEquals((long)this.values.length, (long)this.multimap.size());
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertEquals((long)this.values.length, (long)collection.size());
        Assert.assertFalse((boolean)collection.retainAll(Arrays.asList(this.values)));
        Assert.assertEquals((long)this.values.length, (long)this.multimap.size());
        Assert.assertEquals((long)this.values.length, (long)collection.size());
        Assert.assertTrue((boolean)collection.retainAll(Collections.singleton(this.values[0])));
        Assert.assertEquals((long)1L, (long)this.multimap.size());
        Assert.assertEquals((long)1L, (long)collection.size());
    }

    @Test
    public void shouldRetainNoneInValueCollection() {
        for (String value : this.values) {
            this.multimap.put((Object)this.keys[0], (Object)value);
        }
        Assert.assertEquals((long)this.values.length, (long)this.multimap.size());
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertEquals((long)this.values.length, (long)collection.size());
        Assert.assertTrue((boolean)collection.retainAll(Collections.emptySet()));
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test
    public void shouldSuccessfullyRetainAllInValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertFalse((boolean)collection.retainAll(Arrays.asList(this.values)));
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertEquals((long)1L, (long)collection.size());
        Assert.assertFalse((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)1L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyRetainAllInEmptyValueCollection() {
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertFalse((boolean)collection.retainAll(Arrays.asList(this.values)));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
    }

    @Test
    public void shouldSuccessfullyRetainAllInEmptiedValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        collection.clear();
        Assert.assertFalse((boolean)collection.retainAll(Arrays.asList(this.values)));
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)this.multimap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.multimap.size());
    }

    @Test
    public void shouldProduceHashCodeOfEmptyValueCollection() {
        this.multimap.get((Object)this.keys[0]).hashCode();
    }

    @Test
    public void shouldProduceHashCodeOfEmptiedValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        collection.clear();
        collection.hashCode();
    }

    @Test
    public void shouldCompareEqualityOfEmptyValueCollection() {
        Collection collection = this.multimap.get((Object)this.keys[0]);
        Assert.assertNotEquals((Object)this, (Object)collection);
        Assert.assertNotEquals((Object)collection, (Object)this);
        if (collection instanceof List) {
            Assert.assertEquals(Collections.emptyList(), (Object)collection);
            Assert.assertEquals((Object)collection, Collections.emptyList());
        } else if (collection instanceof Set) {
            Assert.assertEquals(Collections.emptySet(), (Object)collection);
            Assert.assertEquals((Object)collection, Collections.emptySet());
        }
    }

    @Test
    public void shouldCompareEqualityOfEmptiedValueCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        Collection collection = this.multimap.get((Object)this.keys[0]);
        collection.clear();
        Assert.assertNotEquals((Object)this, (Object)collection);
        Assert.assertNotEquals((Object)collection, (Object)this);
        if (collection instanceof List) {
            Assert.assertEquals(Collections.emptyList(), (Object)collection);
            Assert.assertEquals((Object)collection, Collections.emptyList());
        } else if (collection instanceof Set) {
            Assert.assertEquals(Collections.emptySet(), (Object)collection);
            Assert.assertEquals((Object)collection, Collections.emptySet());
        }
    }

    protected <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new ImmutableMapEntry(key, value);
    }

    protected <K, V> void assertEntries(Multimap<K, V> multimap, Map.Entry<K, V> entry) {
        this.assertEntries(multimap, Collections.singletonList(entry));
    }

    @SafeVarargs
    protected final <K, V> void assertEntries(Multimap<K, V> multimap, Map.Entry<K, V> ... entries) {
        this.assertEntries(multimap, Arrays.asList(entries));
    }

    protected <K, V> void assertEntries(Multimap<K, V> multimap, Collection<Map.Entry<K, V>> entries) {
        Collection actualEntries = multimap.entries();
        Assert.assertThat((Object)actualEntries.size(), (Matcher)Is.is((Object)entries.size()));
        Assert.assertThat((Object)actualEntries.containsAll(entries), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)entries.containsAll(actualEntries), (Matcher)Is.is((Object)true));
    }

    protected <K, V> void assertKeys(Multimap<K, V> multimap, K key) {
        this.assertKeys(multimap, (Collection<K>)Collections.singletonList(key));
    }

    @SafeVarargs
    protected final <K, V> void assertKeys(Multimap<K, V> multimap, K ... keys) {
        this.assertKeys(multimap, (Collection<K>)Arrays.asList(keys));
    }

    protected <K, V> void assertKeys(Multimap<K, V> multimap, Collection<K> expectedKeys) {
        Set actualKeys = multimap.keySet();
        Assert.assertThat((Object)actualKeys.size(), (Matcher)Is.is((Object)expectedKeys.size()));
        Assert.assertThat((Object)actualKeys.containsAll(expectedKeys), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)expectedKeys.containsAll(actualKeys), (Matcher)Is.is((Object)true));
    }

    protected <K, V> void assertValues(Multimap<K, V> multimap, K key, V value) {
        Collection<V> expectedValues = null;
        expectedValues = this.valuesAllowDuplicates() ? Collections.singletonList(value) : Collections.singleton(value);
        this.assertValues(multimap, key, expectedValues);
    }

    @SafeVarargs
    protected final <K, V> void assertValues(Multimap<K, V> multimap, K key, V ... values) {
        Collection<V> expectedValues = null;
        expectedValues = this.valuesAllowDuplicates() ? Arrays.asList(values) : new HashSet<V>(Arrays.asList(values));
        this.assertValues(multimap, key, expectedValues);
    }

    protected <K, V> void assertValues(Multimap<K, V> multimap, K key, Collection<V> expectedValues) {
        Collection actualValues = multimap.get(key);
        Assert.assertThat((Object)actualValues.size(), (Matcher)Is.is((Object)expectedValues.size()));
        if (actualValues instanceof List) {
            Assert.assertThat((Object)actualValues, (Matcher)Is.is(expectedValues));
            Iterator actualIter = actualValues.iterator();
            Iterator<V> expectedIter = expectedValues.iterator();
            while (expectedIter.hasNext()) {
                Object actual = actualIter.next();
                V expected = expectedIter.next();
                Assert.assertThat(actual, (Matcher)Is.is(expected));
            }
        } else {
            Assert.assertThat((Object)actualValues.containsAll(expectedValues), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)expectedValues.containsAll(actualValues), (Matcher)Is.is((Object)true));
        }
    }
}

