/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.modeshape.common.collection.ring.DependentOnPointers;
import org.modeshape.common.collection.ring.Pointer;
import org.modeshape.common.collection.ring.Pointers;

public class TrailingPointer
extends Pointer
implements DependentOnPointers {
    private static final Pointer[] EMPTY_ARRAY = new Pointer[0];
    private static final AtomicReferenceFieldUpdater<TrailingPointer, Pointer[]> STAY_BEHIND_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TrailingPointer.class, Pointer[].class, "stayBehinds");
    private volatile Pointer[] stayBehinds;

    public TrailingPointer(Pointer ... stayBehinds) {
        this(INITIAL_VALUE, stayBehinds);
    }

    public TrailingPointer(long initialValue, Pointer ... stayBehinds) {
        super(initialValue);
        this.stayBehinds = stayBehinds == null ? EMPTY_ARRAY : stayBehinds;
    }

    @Override
    public long get() {
        return Math.max(INITIAL_VALUE, Pointers.getMinimum(this.stayBehinds, Long.MAX_VALUE) - 1L);
    }

    @Override
    public void stayBehind(Pointer ... pointers) {
        Pointers.add(this, STAY_BEHIND_UPDATER, null, pointers);
    }

    @Override
    public boolean ignore(Pointer pointer) {
        return Pointers.remove(this, STAY_BEHIND_UPDATER, pointer);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Pointer pointer : this.stayBehinds) {
            sb.append(pointer).append(",");
        }
        sb.append(']');
        return sb.toString();
    }
}

