/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.cmis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.modeshape.connector.cmis.AclObjectId;
import org.modeshape.connector.cmis.CmisConnectorBinary;
import org.modeshape.connector.cmis.CmisLexicon;
import org.modeshape.connector.cmis.Converter;
import org.modeshape.connector.cmis.Nodes;
import org.modeshape.connector.cmis.ObjectId;
import org.modeshape.connector.cmis.Prefix;
import org.modeshape.connector.cmis.Properties;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.spi.federation.Connector;
import org.modeshape.jcr.spi.federation.DocumentChanges;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.schematic.document.Binary;
import org.modeshape.schematic.document.Document;

public class CmisConnector
extends Connector {
    private static final String REPOSITORY_INFO_ID = "repositoryInfo";
    private static final String REPOSITORY_INFO_NODE_NAME = "repositoryInfo";
    private Session session;
    private ValueFactories factories;
    private String aclService;
    private String discoveryService;
    private String multifilingService;
    private String navigationService;
    private String objectService;
    private String policyService;
    private String relationshipService;
    private String repositoryService;
    private String versioningService;
    private String repositoryId;
    private Properties properties;
    private Nodes nodes;
    private Prefix prefixes = new Prefix();
    private final OperationContext ctx = new OperationContextImpl();

    public CmisConnector() {
        this.ctx.setIncludeAcls(true);
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.initialize(registry, nodeTypeManager);
        this.factories = this.getContext().getValueFactories();
        this.properties = new Properties(this.getContext().getValueFactories());
        this.nodes = new Nodes();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.aclService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.discoveryService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.multifilingService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.navigationService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.objectService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.policyService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.relationshipService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.repositoryService);
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.versioningService);
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", this.repositoryId);
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        this.session = factory.createSession(parameter, null, (AuthenticationProvider)new StandardAuthenticationProvider(), null, null);
        registry.registerNamespace("cmis", "http://www.modeshape.org/cmis/1.0");
        this.importTypes(this.session.getTypeDescendants(null, Integer.MAX_VALUE, true), nodeTypeManager, registry);
        this.registerRepositoryInfoType(nodeTypeManager);
    }

    public org.modeshape.schematic.document.Document getDocumentById(String id) {
        ObjectId objectId = ObjectId.valueOf(id);
        switch (objectId.getType()) {
            case REPOSITORY_INFO: {
                return this.cmisRepository();
            }
            case CONTENT: {
                return this.cmisContent(objectId.getIdentifier());
            }
            case OBJECT: {
                return this.cmisObject(objectId.getIdentifier());
            }
            case ACL: {
                return this.cmisAccessList(objectId.getIdentifier());
            }
            case PERMISSIONS: {
                return this.cmisPermission(objectId.getIdentifier());
            }
        }
        return null;
    }

    public String getDocumentId(String path) {
        return this.session.getObjectByPath(path).getId();
    }

    public Collection<String> getDocumentPathsById(String id) {
        CmisObject obj = this.session.getObject(id);
        if (obj instanceof Folder) {
            return Collections.singletonList(((Folder)obj).getPath());
        }
        if (obj instanceof Document) {
            Document doc = (Document)obj;
            List parents = doc.getParents();
            ArrayList<String> paths = new ArrayList<String>(parents.size());
            for (Folder parent : doc.getParents()) {
                paths.add(parent.getPath() + "/" + doc.getName());
            }
            return paths;
        }
        return Collections.emptyList();
    }

    public boolean removeDocument(String id) {
        ObjectId objectId = ObjectId.valueOf(id);
        switch (objectId.getType()) {
            case REPOSITORY_INFO: {
                return false;
            }
            case CONTENT: {
                String cmisId = objectId.getIdentifier();
                Document doc = (Document)this.session.getObject(cmisId);
                if (doc == null) {
                    return false;
                }
                doc.deleteContentStream();
                return true;
            }
            case OBJECT: {
                Object object = null;
                try {
                    this.session.getObject(objectId.getIdentifier());
                }
                catch (CmisObjectNotFoundException e) {
                    return false;
                }
                if (object == null) {
                    return false;
                }
                object.delete(true);
                return true;
            }
        }
        return false;
    }

    public boolean hasDocument(String id) {
        ObjectId objectId = ObjectId.valueOf(id);
        switch (objectId.getType()) {
            case REPOSITORY_INFO: {
                return true;
            }
            case CONTENT: {
                String cmisId = objectId.getIdentifier();
                return this.session.getObject(cmisId) != null;
            }
            case ACL: 
            case PERMISSIONS: {
                return true;
            }
        }
        return this.session.getObject(id) != null;
    }

    public void storeDocument(org.modeshape.schematic.document.Document document) {
        ObjectId objectId = ObjectId.valueOf(document.getString("key"));
        ObjectId parentId = ObjectId.valueOf(document.getString("parent"));
        if (parentId.getType() == ObjectId.Type.ACL) {
            return;
        }
        switch (objectId.getType()) {
            case REPOSITORY_INFO: {
                return;
            }
            case CONTENT: {
                String cmisId = objectId.getIdentifier();
                CmisObject cmisObject = this.session.getObject(cmisId);
                if (cmisObject == null) {
                    return;
                }
                ContentStream stream = this.jcrBinaryContent(document);
                if (stream == null) break;
                ((Document)cmisObject).setContentStream(stream, true);
                break;
            }
            case OBJECT: {
                org.modeshape.schematic.document.Document jcrProperties = document.getDocument("properties");
                if (jcrProperties == null) {
                    return;
                }
                CmisObject cmisObject = this.session.getObject(objectId.getIdentifier());
                if (cmisObject == null) {
                    return;
                }
                HashMap<String, Object> updateProperties = new HashMap<String, Object>();
                Map propDefs = cmisObject.getBaseType().getPropertyDefinitions();
                for (Document.Field field : jcrProperties.fields()) {
                    String namespaceUri = field.getName();
                    org.modeshape.schematic.document.Document props = field.getValueAsDocument();
                    String prefix = this.prefixes.value(namespaceUri);
                    for (Document.Field property : props.fields()) {
                        String jcrPropertyName = prefix + property.getName();
                        String cmisPropertyName = this.properties.findCmisName(jcrPropertyName);
                        PropertyDefinition pdef = (PropertyDefinition)propDefs.get(cmisPropertyName);
                        if (pdef == null) {
                            return;
                        }
                        Object cmisValue = this.properties.cmisValue(pdef, property);
                        updateProperties.put(cmisPropertyName, cmisValue);
                    }
                }
                if (updateProperties.isEmpty()) break;
                cmisObject.updateProperties(updateProperties);
            }
        }
    }

    public void updateDocument(DocumentChanges delta) {
        ObjectId parentId = ObjectId.valueOf(delta.getDocument().getString("parent"));
        if (parentId.getType().equals((Object)ObjectId.Type.ACL)) {
            return;
        }
        ObjectId objectId = ObjectId.valueOf(delta.getDocumentId());
        switch (objectId.getType()) {
            case REPOSITORY_INFO: {
                break;
            }
            case CONTENT: {
                String cmisId = objectId.getIdentifier();
                CmisObject cmisObject = this.session.getObject(cmisId);
                if (cmisObject == null) {
                    return;
                }
                DocumentChanges.PropertyChanges changes = delta.getPropertyChanges();
                if (!changes.getRemoved().isEmpty()) {
                    ((Document)cmisObject).deleteContentStream();
                    break;
                }
                ContentStream stream = this.jcrBinaryContent(delta.getDocument());
                if (stream == null) break;
                ((Document)cmisObject).setContentStream(stream, true);
                break;
            }
            case OBJECT: {
                PropertyDefinition pdef;
                Object cmisPropertyName;
                String jcrPropertyName;
                String prefix;
                CmisObject cmisObject = this.session.getObject(objectId.getIdentifier());
                DocumentChanges.PropertyChanges changes = delta.getPropertyChanges();
                org.modeshape.schematic.document.Document props = delta.getDocument().getDocument("properties");
                if (cmisObject == null) {
                    return;
                }
                HashMap<Object, Object> updateProperties = new HashMap<Object, Object>();
                Map propDefs = cmisObject.getBaseType().getPropertyDefinitions();
                ArrayList modifications = new ArrayList();
                modifications.addAll(changes.getAdded());
                modifications.addAll(changes.getChanged());
                for (Name name : modifications) {
                    Updatability updatability;
                    prefix = this.prefixes.value(name.getNamespaceUri());
                    jcrPropertyName = prefix != null ? prefix + ":" + name.getLocalName() : name.getLocalName();
                    cmisPropertyName = this.properties.findCmisName(jcrPropertyName);
                    pdef = (PropertyDefinition)propDefs.get(cmisPropertyName);
                    if (pdef == null || (updatability = pdef.getUpdatability()) != Updatability.READWRITE) continue;
                    org.modeshape.schematic.document.Document jcrValues = props.getDocument(name.getNamespaceUri());
                    updateProperties.put(cmisPropertyName, this.properties.cmisValue(pdef, name.getLocalName(), jcrValues));
                }
                for (Name name : changes.getRemoved()) {
                    prefix = this.prefixes.value(name.getNamespaceUri());
                    jcrPropertyName = prefix != null ? prefix + ":" + name.getLocalName() : name.getLocalName();
                    cmisPropertyName = this.properties.findCmisName(jcrPropertyName);
                    pdef = (PropertyDefinition)propDefs.get(cmisPropertyName);
                    if (pdef == null) continue;
                    updateProperties.put(cmisPropertyName, null);
                }
                if (!updateProperties.isEmpty()) {
                    cmisObject.updateProperties(updateProperties);
                }
                DocumentChanges.ChildrenChanges childrenChanges = delta.getChildrenChanges();
                HashMap renamed = new HashMap();
                renamed.putAll(childrenChanges.getRenamed());
                renamed.putAll(childrenChanges.getAppended());
                for (String key : renamed.keySet()) {
                    CmisObject object = this.session.getObject(key);
                    if (object == null) continue;
                    String before = object.getName();
                    String after = ((Name)renamed.get(key)).getLocalName();
                    if (after.equals(before)) continue;
                    if (this.isExistCmisObject(((Folder)((FileableCmisObject)object).getParents().get(0)).getPath() + "/" + after)) {
                        after = after + "-temp";
                    }
                    this.rename(object, after);
                }
                if (!delta.getParentChanges().hasNewPrimaryParent()) break;
                FileableCmisObject object = (FileableCmisObject)cmisObject;
                CmisObject source = (CmisObject)object.getParents().get(0);
                CmisObject destination = this.session.getObject(delta.getParentChanges().getNewPrimaryParent());
                object.move((org.apache.chemistry.opencmis.client.api.ObjectId)source, (org.apache.chemistry.opencmis.client.api.ObjectId)destination);
                String name = object.getName();
                if (!name.endsWith("-temp")) break;
                this.rename((CmisObject)object, name.replace("-temp", ""));
                break;
            }
        }
    }

    private boolean isExistCmisObject(String path) {
        try {
            this.session.getObjectByPath(path);
            return true;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }

    private void rename(CmisObject object, String name) {
        HashMap<String, String> newName = new HashMap<String, String>();
        newName.put("cmis:name", name);
        object.updateProperties(newName);
    }

    public boolean isReadonly() {
        return false;
    }

    public String newDocumentId(String parentId, Name name, Name primaryType) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (primaryType.getLocalName().equals("resource")) {
            return ObjectId.toString(ObjectId.Type.CONTENT, parentId);
        }
        String jcrNodeType = primaryType.toString();
        String cmisObjectTypeName = this.nodes.findCmisName(jcrNodeType);
        Folder parent = (Folder)this.session.getObject(parentId);
        ObjectType objectType = this.session.getTypeDefinition(cmisObjectTypeName);
        Map propDefs = objectType.getPropertyDefinitions();
        Collection list = propDefs.values();
        for (PropertyDefinition pdef : list) {
            if (!pdef.isRequired().booleanValue()) continue;
            params.put(pdef.getId(), "");
        }
        String path = parent.getPath() + "/" + name.getLocalName();
        params.put("cmis:objectTypeId", objectType.getId());
        params.put("cmis:name", name.getLocalName());
        switch (objectType.getBaseTypeId()) {
            case CMIS_FOLDER: {
                params.put("cmis:path", path);
                return ObjectId.toString(ObjectId.Type.OBJECT, parent.createFolder(params).getId());
            }
            case CMIS_DOCUMENT: {
                return ObjectId.toString(ObjectId.Type.OBJECT, parent.createDocument(params, null, VersioningState.NONE).getId());
            }
        }
        return null;
    }

    private org.modeshape.schematic.document.Document cmisObject(String id) {
        CmisObject cmisObject;
        try {
            cmisObject = this.session.getObject(id);
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
        if (cmisObject == null) {
            return null;
        }
        switch (cmisObject.getBaseTypeId()) {
            case CMIS_FOLDER: {
                return this.cmisFolder(cmisObject);
            }
            case CMIS_DOCUMENT: {
                return this.cmisDocument(cmisObject);
            }
        }
        return null;
    }

    private org.modeshape.schematic.document.Document cmisFolder(CmisObject cmisObject) {
        Folder folder = (Folder)cmisObject;
        DocumentWriter writer = this.newDocument(ObjectId.toString(ObjectId.Type.OBJECT, folder.getId()));
        ObjectType objectType = cmisObject.getType();
        if (objectType.isBaseType()) {
            writer.setPrimaryType("{http://www.jcp.org/jcr/nt/1.0}folder");
        } else {
            writer.setPrimaryType(objectType.getId());
        }
        writer.setParent(folder.getParentId());
        writer.addMixinType("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        writer.addMixinType("{http://www.jcp.org/jcr/mix/1.0}lastModified");
        this.cmisProperties((CmisObject)folder, writer);
        this.cmisChildren(folder, writer);
        writer.addMixinType("mode:accessControllable");
        writer.addChild(ObjectId.toString(ObjectId.Type.ACL, folder.getId()), "mode:acl");
        if (folder.isRootFolder()) {
            writer.addChild(ObjectId.toString(ObjectId.Type.REPOSITORY_INFO, ""), "repositoryInfo");
        }
        return writer.document();
    }

    public org.modeshape.schematic.document.Document cmisDocument(CmisObject cmisObject) {
        Document doc = (Document)cmisObject;
        DocumentWriter writer = this.newDocument(ObjectId.toString(ObjectId.Type.OBJECT, doc.getId()));
        ObjectType objectType = cmisObject.getType();
        if (objectType.isBaseType()) {
            writer.setPrimaryType("{http://www.jcp.org/jcr/nt/1.0}file");
        } else {
            writer.setPrimaryType(objectType.getId());
        }
        List parents = doc.getParents();
        ArrayList<String> parentIds = new ArrayList<String>();
        for (Folder f : parents) {
            parentIds.add(ObjectId.toString(ObjectId.Type.OBJECT, f.getId()));
        }
        writer.setParents(parentIds);
        writer.addMixinType("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        writer.addMixinType("{http://www.jcp.org/jcr/mix/1.0}lastModified");
        this.cmisProperties((CmisObject)doc, writer);
        writer.addChild(ObjectId.toString(ObjectId.Type.CONTENT, doc.getId()), "jcr:content");
        writer.addMixinType("mode:accessControllable");
        writer.addChild(ObjectId.toString(ObjectId.Type.ACL, cmisObject.getId()), "mode:acl");
        return writer.document();
    }

    private org.modeshape.schematic.document.Document cmisContent(String id) {
        DocumentWriter writer = this.newDocument(ObjectId.toString(ObjectId.Type.CONTENT, id));
        Document doc = (Document)this.session.getObject(id);
        writer.setPrimaryType("{http://www.jcp.org/jcr/nt/1.0}resource");
        writer.setParent(id);
        ContentStream contentStream = doc.getContentStream();
        if (contentStream != null) {
            CmisConnectorBinary content = new CmisConnectorBinary(contentStream, this.getSourceName(), id, this.getMimeTypeDetector());
            writer.addProperty("jcr:data", (Object)content);
            writer.addProperty("jcr:mimeType", (Object)contentStream.getMimeType());
        }
        Property lastModified = doc.getProperty("cmis:lastModificationDate");
        Property lastModifiedBy = doc.getProperty("cmis:lastModifiedBy");
        writer.addProperty(JcrLexicon.LAST_MODIFIED, this.properties.jcrValues(lastModified));
        writer.addProperty(JcrLexicon.LAST_MODIFIED_BY, this.properties.jcrValues(lastModifiedBy));
        return writer.document();
    }

    public ExternalBinaryValue getBinaryValue(String id) {
        Document doc = (Document)this.session.getObject(id);
        if (doc == null) {
            return null;
        }
        ContentStream contentStream = doc.getContentStream();
        if (contentStream == null) {
            return null;
        }
        return new CmisConnectorBinary(contentStream, this.getSourceName(), id, this.getMimeTypeDetector());
    }

    private void cmisProperties(CmisObject object, DocumentWriter writer) {
        List list = object.getProperties();
        for (Property property : list) {
            String pname = this.properties.findJcrName(property.getId());
            if (pname == null) continue;
            writer.addProperty(pname, this.properties.jcrValues(property));
        }
    }

    private void cmisChildren(Folder folder, DocumentWriter writer) {
        ItemIterable it = folder.getChildren();
        for (CmisObject obj : it) {
            writer.addChild(obj.getId(), obj.getName());
        }
    }

    private org.modeshape.schematic.document.Document cmisRepository() {
        RepositoryInfo info = this.session.getRepositoryInfo();
        DocumentWriter writer = this.newDocument(ObjectId.toString(ObjectId.Type.REPOSITORY_INFO, ""));
        writer.setPrimaryType(CmisLexicon.REPOSITORY);
        writer.setId("repositoryInfo");
        writer.addProperty(CmisLexicon.VENDOR_NAME, (Object)info.getVendorName());
        writer.addProperty(CmisLexicon.PRODUCT_NAME, (Object)info.getProductName());
        writer.addProperty(CmisLexicon.PRODUCT_VERSION, (Object)info.getProductVersion());
        return writer.document();
    }

    private org.modeshape.schematic.document.Document cmisAccessList(String id) {
        DocumentWriter writer = this.newDocument(ObjectId.toString(ObjectId.Type.ACL, id));
        writer.setPrimaryType(ModeShapeLexicon.ACCESS_LIST_NODE_TYPE_STRING);
        writer.setParent(id);
        CmisObject obj = this.session.getObject(id);
        obj = this.session.getObject((org.apache.chemistry.opencmis.client.api.ObjectId)obj, this.ctx);
        Acl acl = obj.getAcl();
        List entries = acl.getAces();
        for (Ace entry : entries) {
            String entryId = AclObjectId.encode(id, entry.getPrincipalId());
            writer.addChild(ObjectId.toString(ObjectId.Type.PERMISSIONS, entryId), ModeShapeLexicon.PERMISSION.toString());
        }
        return writer.document();
    }

    private org.modeshape.schematic.document.Document cmisPermission(String id) {
        String cmisObjectId = AclObjectId.cmisObjectId(id);
        String entryId = AclObjectId.entryId(id);
        DocumentWriter writer = this.newDocument(ObjectId.toString(ObjectId.Type.PERMISSIONS, id));
        writer.setPrimaryType(ModeShapeLexicon.PERMISSION.toString());
        writer.setParent(id);
        Acl acl = this.session.getObject(cmisObjectId, this.ctx).getAcl();
        List entries = acl.getAces();
        for (Ace entry : entries) {
            if (!entry.getPrincipalId().equals(entryId)) continue;
            String name = entry.getPrincipal().getId();
            name = Converter.jcrPrincipal(name);
            writer.addProperty(ModeShapeLexicon.PERMISSION_PRINCIPAL_NAME.getLocalName(), (Object)name);
            List perms = entry.getPermissions();
            writer.addProperty(ModeShapeLexicon.PERMISSION_PRIVILEGES_NAME.getLocalName(), (Object[])Converter.jcrPermissions(perms));
        }
        return writer.document();
    }

    private ContentStream jcrBinaryContent(org.modeshape.schematic.document.Document document) {
        org.modeshape.schematic.document.Document props = document.getDocument("properties").getDocument("http://www.jcp.org/jcr/1.0");
        Binary value = props.getBinary("data");
        if (value == null) {
            return null;
        }
        byte[] content = value.getBytes();
        String fileName = props.getString("fileName");
        String mimeType = props.getString("mimeType");
        ByteArrayInputStream bin = new ByteArrayInputStream(content);
        bin.reset();
        return new ContentStreamImpl(fileName, BigInteger.valueOf(content.length), mimeType, (InputStream)bin);
    }

    private void importTypes(List<Tree<ObjectType>> types, NodeTypeManager typeManager, NamespaceRegistry registry) throws RepositoryException {
        for (Tree<ObjectType> tree : types) {
            this.importType((ObjectType)tree.getItem(), typeManager, registry);
            this.importTypes(tree.getChildren(), typeManager, registry);
        }
    }

    public void importType(ObjectType cmisType, NodeTypeManager typeManager, NamespaceRegistry registry) throws RepositoryException {
        NodeTypeTemplate type = typeManager.createNodeTypeTemplate();
        type.setName(cmisType.getId());
        type.setAbstract(false);
        type.setMixin(false);
        type.setOrderableChildNodes(true);
        type.setQueryable(true);
        if (!cmisType.isBaseType()) {
            type.setDeclaredSuperTypeNames(this.superTypes(cmisType));
        }
        Map props = cmisType.getPropertyDefinitions();
        Set names = props.keySet();
        for (String name : names) {
            PropertyDefinition pd = (PropertyDefinition)props.get(name);
            PropertyDefinitionTemplate pt = typeManager.createPropertyDefinitionTemplate();
            pt.setRequiredType(this.properties.getJcrType(pd.getPropertyType()));
            pt.setAutoCreated(false);
            pt.setAvailableQueryOperators(new String[0]);
            pt.setName(name);
            pt.setMandatory(pd.isRequired().booleanValue());
            type.getPropertyDefinitionTemplates().add(pt);
        }
        NodeTypeDefinition[] nodeDefs = new NodeTypeDefinition[]{type};
        typeManager.registerNodeTypes(nodeDefs, true);
    }

    private String[] superTypes(ObjectType cmisType) {
        if (cmisType.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
            return new String[]{"nt:folder"};
        }
        if (cmisType.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT) {
            return new String[]{"nt:file"};
        }
        return new String[]{cmisType.getParentType().getId()};
    }

    private void registerRepositoryInfoType(NodeTypeManager typeManager) throws RepositoryException {
        NodeTypeTemplate type = typeManager.createNodeTypeTemplate();
        type.setName("cmis:repository");
        type.setAbstract(false);
        type.setMixin(false);
        type.setOrderableChildNodes(true);
        type.setQueryable(true);
        type.setDeclaredSuperTypeNames(new String[]{"nt:folder"});
        PropertyDefinitionTemplate vendorName = typeManager.createPropertyDefinitionTemplate();
        vendorName.setAutoCreated(false);
        vendorName.setName("cmis:vendorName");
        vendorName.setMandatory(false);
        type.getPropertyDefinitionTemplates().add(vendorName);
        PropertyDefinitionTemplate productName = typeManager.createPropertyDefinitionTemplate();
        productName.setAutoCreated(false);
        productName.setName("cmis:productName");
        productName.setMandatory(false);
        type.getPropertyDefinitionTemplates().add(productName);
        PropertyDefinitionTemplate productVersion = typeManager.createPropertyDefinitionTemplate();
        productVersion.setAutoCreated(false);
        productVersion.setName("cmis:productVersion");
        productVersion.setMandatory(false);
        type.getPropertyDefinitionTemplates().add(productVersion);
        NodeTypeDefinition[] nodeDefs = new NodeTypeDefinition[]{type};
        typeManager.registerNodeTypes(nodeDefs, true);
    }
}

