/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.cmis;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.UriFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.schematic.document.Document;

public class Properties {
    private static final String[] map = new String[]{"cmis:objectId = jcr:uuid", "cmis:createdBy = jcr:createdBy", "cmis:creationDate = jcr:created", "cmis:lastModificationDate = jcr:lastModified", "cmis:lastModifiedBy = -"};
    private ValueFactories valueFactories;
    private ArrayList<Relation> list = new ArrayList();

    public Properties(ValueFactories valueFactories) {
        this.valueFactories = valueFactories;
        for (int i = 0; i < map.length; ++i) {
            String[] tokens = map[i].split("=");
            String lhs = tokens[0].trim();
            String rhs = tokens[1].trim();
            lhs = lhs.equals("-") ? null : lhs;
            rhs = rhs.equals("-") ? null : rhs;
            this.list.add(new Relation(lhs, rhs));
        }
    }

    public String findJcrName(String cmisName) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).cmisName == null || !this.list.get(i).cmisName.equals(cmisName)) continue;
            return this.list.get(i).jcrName;
        }
        return cmisName;
    }

    public String findCmisName(String jcrName) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).jcrName == null || !this.list.get(i).jcrName.equals(jcrName)) continue;
            return this.list.get(i).cmisName;
        }
        return jcrName;
    }

    public int getJcrType(PropertyType propertyType) {
        switch (propertyType) {
            case BOOLEAN: {
                return 6;
            }
            case DATETIME: {
                return 5;
            }
            case DECIMAL: {
                return 12;
            }
            case HTML: {
                return 1;
            }
            case INTEGER: {
                return 3;
            }
            case URI: {
                return 11;
            }
            case ID: {
                return 1;
            }
        }
        return 0;
    }

    public Object cmisValue(PropertyDefinition<?> pdef, Document.Field field) {
        switch (pdef.getPropertyType()) {
            case STRING: {
                return field.getValueAsString();
            }
            case BOOLEAN: {
                return field.getValueAsBoolean();
            }
            case DECIMAL: {
                return BigDecimal.valueOf(field.getValueAsInt().intValue());
            }
            case INTEGER: {
                return field.getValueAsInt();
            }
            case DATETIME: {
                return new GregorianCalendar();
            }
            case URI: {
                try {
                    return new URI(field.getValueAsString());
                }
                catch (Exception exception) {
                    break;
                }
            }
            case ID: {
                return field.getValueAsUuid();
            }
            case HTML: {
                return field.getValueAsString();
            }
        }
        return null;
    }

    public Object cmisValue(PropertyDefinition<?> pdef, String jcrName, Document document) {
        switch (pdef.getPropertyType()) {
            case STRING: {
                return document.getString(jcrName);
            }
            case BOOLEAN: {
                return document.getBoolean(jcrName);
            }
            case DECIMAL: {
                return BigDecimal.valueOf(document.getLong(jcrName));
            }
            case INTEGER: {
                return document.getInteger(jcrName);
            }
            case DATETIME: {
                return new GregorianCalendar();
            }
            case URI: {
                try {
                    return new URI(document.getString(jcrName));
                }
                catch (Exception exception) {
                    break;
                }
            }
            case ID: {
                return document.getString(jcrName);
            }
            case HTML: {
                return document.getString(jcrName);
            }
        }
        return null;
    }

    public Object[] jcrValues(Property<?> property) {
        List values = property.getValues();
        switch (property.getType()) {
            case STRING: {
                return this.asStrings(values);
            }
            case BOOLEAN: {
                return this.asBooleans(values);
            }
            case DECIMAL: {
                return this.asDecimals(values);
            }
            case INTEGER: {
                return this.asIntegers(values);
            }
            case DATETIME: {
                return this.asDateTime(values);
            }
            case URI: {
                return this.asURI(values);
            }
            case ID: {
                return this.asIDs(values);
            }
            case HTML: {
                return this.asHTMLs(values);
            }
        }
        return null;
    }

    private Boolean[] asBooleans(List<Object> values) {
        ValueFactory factory = this.valueFactories.getBooleanFactory();
        Boolean[] res = new Boolean[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Boolean)factory.create(values.get(i));
        }
        return res;
    }

    private String[] asStrings(List<Object> values) {
        StringFactory factory = this.valueFactories.getStringFactory();
        String[] res = new String[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)factory.create(values.get(i));
        }
        return res;
    }

    private Long[] asIntegers(List<Object> values) {
        ValueFactory factory = this.valueFactories.getLongFactory();
        Long[] res = new Long[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Long)factory.create(values.get(i));
        }
        return res;
    }

    private BigDecimal[] asDecimals(List<Object> values) {
        ValueFactory factory = this.valueFactories.getDecimalFactory();
        BigDecimal[] res = new BigDecimal[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (BigDecimal)factory.create(values.get(i));
        }
        return res;
    }

    private DateTime[] asDateTime(List<Object> values) {
        DateTimeFactory factory = this.valueFactories.getDateFactory();
        DateTime[] res = new DateTime[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (DateTime)factory.create(((GregorianCalendar)values.get(i)).getTime());
        }
        return res;
    }

    private URI[] asURI(List<Object> values) {
        UriFactory factory = this.valueFactories.getUriFactory();
        URI[] res = new URI[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (URI)factory.create(((GregorianCalendar)values.get(i)).getTime());
        }
        return res;
    }

    private String[] asIDs(List<Object> values) {
        StringFactory factory = this.valueFactories.getStringFactory();
        String[] res = new String[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)factory.create(values.get(i));
        }
        return res;
    }

    private String[] asHTMLs(List<Object> values) {
        StringFactory factory = this.valueFactories.getStringFactory();
        String[] res = new String[values.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)factory.create(values.get(i));
        }
        return res;
    }

    private class Relation {
        private String jcrName;
        private String cmisName;

        private Relation(String cmisName, String jcrName) {
            this.cmisName = cmisName;
            this.jcrName = jcrName;
        }
    }
}

