/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.cmis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.MultiUseAbstractTest;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.value.BinaryValue;

public class CmisConnectorIT
extends MultiUseAbstractTest {
    private static final String CMIS_URL = "http://localhost:8090/";
    private static Logger logger = Logger.getLogger(CmisConnectorIT.class);

    @BeforeClass
    public static void beforeAll() throws Exception {
        boolean isReady = false;
        long maxTime = 30000L;
        long waitingTime = 0L;
        long timeQuant = 500L;
        logger.info((Object)"Waiting for CMIS repository...");
        do {
            try {
                CmisConnectorIT.testDirectChemistryConnect();
                isReady = true;
            }
            catch (Exception e) {
                Thread.sleep(timeQuant);
                waitingTime += timeQuant;
            }
        } while (!isReady && waitingTime < maxTime);
        if (!isReady) {
            throw new IllegalStateException("CMIS repository did not respond withing " + maxTime + " milliseconds");
        }
        logger.info((Object)"CMIS repository has been started successfuly");
        RepositoryConfiguration config = RepositoryConfiguration.read((String)"config/repository-1.json");
        CmisConnectorIT.startRepository((RepositoryConfiguration)config);
    }

    @AfterClass
    public static void afterAll() throws Exception {
        MultiUseAbstractTest.afterAll();
    }

    public static void testDirectChemistryConnect() {
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", "http://localhost:8090/services/ACLService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", "http://localhost:8090/services/DiscoveryService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", "http://localhost:8090/services/MultiFilingService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", "http://localhost:8090/services/NavigationService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", "http://localhost:8090/services/ObjectService10?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", "http://localhost:8090/services/PolicyService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", "http://localhost:8090/services/RelationshipService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", "http://localhost:8090/services/RepositoryService10?wsdl");
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", "http://localhost:8090/services/VersioningService?wsdl");
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", "A1");
        Session session = factory.createSession(parameter);
        Assert.assertTrue((String)"Chemistry session should exists.", (session != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldSeeCmisTypesAsJcrTypes() throws Exception {
        NodeTypeManager manager = CmisConnectorIT.getSession().getWorkspace().getNodeTypeManager();
        NodeTypeIterator it = manager.getNodeType("nt:file").getDeclaredSubtypes();
        while (it.hasNext()) {
            NodeType nodeType = it.nextNodeType();
            Assert.assertTrue((nodeType != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldAccessRootFolder() throws Exception {
        Node root = CmisConnectorIT.getSession().getNode("/cmis");
        Assert.assertTrue((root != null ? 1 : 0) != 0);
    }

    @Test
    public void testRootFolderName() throws Exception {
        Node root = CmisConnectorIT.getSession().getNode("/cmis");
        Assert.assertEquals((Object)"cmis", (Object)root.getName());
    }

    @Test
    public void shouldAccessRepositoryInfo() throws Exception {
        Node repoInfo = CmisConnectorIT.getSession().getNode("/cmis/repositoryInfo");
        Assert.assertTrue((boolean)repoInfo.getProperty("cmis:productName").getString().contains("OpenCMIS"));
        Assert.assertTrue((boolean)repoInfo.getProperty("cmis:productName").getString().contains("InMemory"));
        Assert.assertEquals((Object)"Apache Chemistry", (Object)repoInfo.getProperty("cmis:vendorName").getString());
        Assert.assertTrue((repoInfo.getProperty("cmis:productVersion").getString() != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessFolderByPath() throws Exception {
        Node root = CmisConnectorIT.getSession().getNode("/cmis");
        Assert.assertTrue((root != null ? 1 : 0) != 0);
        Node node1 = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0");
        Assert.assertTrue((node1 != null ? 1 : 0) != 0);
        Node node2 = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Folder-1-0");
        Assert.assertTrue((node2 != null ? 1 : 0) != 0);
        Node node3 = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Folder-1-0/My_Folder-2-0");
        Assert.assertTrue((node3 != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessDocumentPath() throws Exception {
        Node file = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Document-1-0");
        Assert.assertTrue((file != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessBinaryContent() throws Exception {
        Node file = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Document-1-0");
        Node cnt = file.getNode("jcr:content");
        Property value = cnt.getProperty("jcr:data");
        Binary bv = value.getValue().getBinary();
        InputStream is = bv.getStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int b = 0;
        while (b != -1) {
            b = is.read();
            if (b == -1) continue;
            bout.write(b);
        }
        byte[] content = bout.toByteArray();
        String s = new String(content, 0, content.length);
        Assert.assertFalse((String)"Content shouldn't be empty.", (boolean)s.trim().isEmpty());
    }

    @Test
    public void shouldAccessObjectIdPropertyForFolder() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0");
        String objectId = node.getProperty("jcr:uuid").getString();
        Assert.assertTrue((objectId != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessNamePropertyForFolder() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0");
        String name = node.getName();
        Assert.assertEquals((Object)"My_Folder-0-0", (Object)name);
    }

    @Test
    public void shouldAccessCreatedByPropertyForFolder() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0");
        String name = node.getProperty("jcr:createdBy").getString();
        Assert.assertEquals((Object)"unknown", (Object)name);
    }

    @Test
    public void shouldAccessCreationDatePropertyForFolder() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0");
        Calendar date = node.getProperty("jcr:created").getDate();
        Assert.assertTrue((date != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessModificationDatePropertyForFolder() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0");
        Calendar date = node.getProperty("jcr:lastModified").getDate();
        Assert.assertTrue((date != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessObjectIdPropertyForDocument() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Document-1-0");
        String objectId = node.getProperty("jcr:uuid").getString();
        Assert.assertTrue((objectId != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldAccessCreatedByPropertyForDocument() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Document-1-0");
        String name = node.getProperty("jcr:createdBy").getString();
        Assert.assertEquals((Object)"unknown", (Object)name);
    }

    @Test
    public void shouldAccessCreationDatePropertyForDocument() throws Exception {
        Node node = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Document-1-0");
        Calendar date = node.getProperty("jcr:created").getDate();
        Assert.assertTrue((date != null ? 1 : 0) != 0);
    }

    @Test
    public void shouldCreateFolderAndDocument() throws Exception {
        Node root = CmisConnectorIT.getSession().getNode("/cmis");
        String name = "test" + System.currentTimeMillis();
        Node node = root.addNode(name, "nt:folder");
        Assert.assertTrue((boolean)name.equals(node.getName()));
        root = CmisConnectorIT.getSession().getNode("/cmis/" + name);
        Node node1 = root.addNode("test-1", "nt:file");
        byte[] content = "Hello World".getBytes();
        ByteArrayInputStream bin = new ByteArrayInputStream(content);
        bin.reset();
        Node contentNode = node1.addNode("jcr:content", "nt:resource");
        BinaryValue binary = session.getValueFactory().createBinary((InputStream)bin);
        contentNode.setProperty("jcr:data", (Binary)binary);
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        CmisConnectorIT.getSession().save();
    }

    @Test
    public void shouldModifyDocument() throws Exception {
        Node file = CmisConnectorIT.getSession().getNode("/cmis/My_Folder-0-0/My_Document-1-0");
        PropertyIterator it = file.getProperties();
        while (it.hasNext()) {
            Property val = it.nextProperty();
            this.printMessage("property=>" + val);
        }
        file.setProperty("StringProp", "modeshape");
        CmisConnectorIT.getSession().save();
    }

    @Test
    public void shouldBeAbleToMoveExternalNodes() throws Exception {
        Assert.assertNotNull((Object)session.getNode("/cmis/My_Folder-0-0/My_Document-1-0"));
        session.getWorkspace().move("/cmis/My_Folder-0-0/My_Document-1-0", "/cmis/My_Folder-0-1/My_Document-1-X");
        AbstractJcrNode file = session.getNode("/cmis/My_Folder-0-1/My_Document-1-X");
        Assert.assertNotNull((Object)file);
        Assert.assertNotNull((Object)session.getNode("/cmis/My_Folder-0-0"));
        session.getWorkspace().move("/cmis/My_Folder-0-0", "/cmis/My_Folder-0-X");
        AbstractJcrNode folder = session.getNode("/cmis/My_Folder-0-X");
        Assert.assertNotNull((Object)folder);
        Assert.assertEquals((Object)"nt:folder", (Object)folder.getPrimaryNodeType().getName());
        session.getWorkspace().move("/cmis/My_Folder-0-1/My_Document-1-X", "/cmis/My_Folder-0-X/My_Document-1-0");
        session.getWorkspace().move("/cmis/My_Folder-0-X", "/cmis/My_Folder-0-0");
    }

    @Test
    public void shouldContainAccessList() throws Exception {
        AccessControlManager acm = session.getAccessControlManager();
        AccessControlPolicy[] policies = acm.getPolicies("/cmis/My_Folder-0-0");
        Assert.assertEquals((long)1L, (long)policies.length);
    }
}

