/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.cmis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modeshape.jcr.security.SimplePrincipal;

public class Converter {
    private static final String CMIS_ANYONE = "anyone";

    public static String jcrPrincipal(String cmisPrincipal) {
        return cmisPrincipal.equalsIgnoreCase(CMIS_ANYONE) ? SimplePrincipal.EVERYONE.getName() : cmisPrincipal;
    }

    public static String[] jcrPermissions(String cmisPermission) {
        switch (cmisPermission) {
            case "cmis:read": {
                return new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}readAccessControl"};
            }
            case "cmis:write": {
                return new String[]{"{http://www.jcp.org/jcr/1.0}write", "{http://www.jcp.org/jcr/1.0}readAccessControl", "{http://www.jcp.org/jcr/1.0}modifyAccessControl", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement", "{http://www.jcp.org/jcr/1.0}retentionManagement", "{http://www.jcp.org/jcr/1.0}versionManagement"};
            }
            case "cmis:all": {
                return new String[]{"{http://www.jcp.org/jcr/1.0}all"};
            }
        }
        return null;
    }

    public static String[] jcrPermissions(List<String> cmisPermissions) {
        ArrayList list = new ArrayList();
        for (String permission : cmisPermissions) {
            Collections.addAll(list, Converter.jcrPermissions(permission));
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }
}

