/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Driver;
import java.util.Properties;
import javax.naming.Context;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jdbc.AbstractJdbcDriverIntegrationTest;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.LocalJcrDriver;

public class JcrDriverIntegrationTest
extends AbstractJdbcDriverIntegrationTest {
    protected Driver createDriver(JcrRepository repository) throws Exception {
        final Context jndi = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)jndi.lookup(Matchers.anyString())).thenReturn((Object)repository);
        LocalJcrDriver.JcrContextFactory contextFactory = new LocalJcrDriver.JcrContextFactory(){

            public Context createContext(Properties properties) {
                return jndi;
            }
        };
        return new JcrDriver(contextFactory);
    }

    protected String createConnectionUrl(JcrRepository repository) throws Exception {
        return "jdbc:jcr:jndi:jcr/local?repositoryName=" + repository.getName();
    }
}

