/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.util.function.BiPredicate;
import java.util.function.Function;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.ConstantScoreWeightQuery;

@Immutable
public abstract class CompareQuery<ValueType>
extends ConstantScoreWeightQuery {
    protected final ValueType constraintValue;
    protected final BiPredicate<ValueType, ValueType> evaluator;
    protected final Function<String, String> caseOperation;

    protected CompareQuery(String fieldName, ValueType constraintValue, BiPredicate<ValueType, ValueType> evaluator, Function<String, String> caseOperation) {
        super(fieldName);
        this.constraintValue = constraintValue;
        this.caseOperation = caseOperation;
        this.evaluator = evaluator;
        assert (this.constraintValue != null);
        assert (this.evaluator != null);
    }

    @Override
    protected boolean accepts(String value) {
        if (value == null) {
            return false;
        }
        String casedValue = this.caseOperation != null ? this.caseOperation.apply(value) : value;
        ValueType convertedValue = this.convertValue(casedValue);
        return this.evaluator.test(convertedValue, this.constraintValue);
    }

    protected abstract ValueType convertValue(String var1);

    public String toString(String field) {
        return "compare['" + field + "' against '" + this.constraintValue + "']";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        CompareQuery otherQuery = (CompareQuery)((Object)obj);
        return this.sameClassAs(obj) && this.field().equals(otherQuery.field()) && this.constraintValue.equals(otherQuery.constraintValue);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field().hashCode();
        result = 31 * result + this.constraintValue.hashCode();
        return result;
    }
}

