/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.JoinCondition;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.query.qom.ChildCount;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneManagedIndexBuilder;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexUsage;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;

public class LuceneIndexProvider
extends IndexProvider {
    private static final int COST_ESTIMATE = 100;
    private String directory;
    private String path;
    private String relativeTo;
    private String lockFactoryClass;
    private String directoryClass;
    private String analyzerClass;
    private String codec;
    private LuceneConfig luceneConfig;

    protected void doInitialize() throws RepositoryException {
        String baseDir = this.baseDir();
        this.luceneConfig = new LuceneConfig(baseDir, this.lockFactoryClass, this.directoryClass, this.analyzerClass, this.codec, this.environment());
    }

    private String baseDir() throws RepositoryException {
        if (this.directory == null && this.relativeTo != null && this.path != null) {
            try {
                File rel = new File(this.relativeTo);
                File dir = Paths.get(rel.toURI()).resolve(this.path).toFile();
                this.directory = dir.getAbsolutePath();
            }
            catch (RuntimeException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this.directory == null) {
            this.logger().debug("The lucene index provider '{0}' for repository '{1}' will be held in memory", new Object[]{this.getName(), this.getRepositoryName()});
            return null;
        }
        this.logger().debug("Initializing the lucene index provider '{0}' in repository '{1}' at: {2}", new Object[]{this.getName(), this.getRepositoryName(), this.directory});
        return this.directory;
    }

    public void validateProposedIndex(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypesSupplier, Problems problems) {
        LuceneManagedIndexBuilder.validate(defn, problems);
    }

    protected int getCostEstimate() {
        return 100;
    }

    public Long getLatestIndexUpdateTime() {
        return this.luceneConfig.lastSuccessfulCommitTime();
    }

    protected ManagedIndexBuilder getIndexBuilder(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return new LuceneManagedIndexBuilder(this.context(), defn, workspaceName, nodeTypesSupplier, matcher, this.luceneConfig);
    }

    protected IndexUsage evaluateUsage(QueryContext context, final IndexCostCalculator calculator, final IndexDefinition defn) {
        return new IndexUsage(context, calculator, defn){

            protected boolean applies(ChildCount operand) {
                return false;
            }

            protected boolean applies(DynamicOperand operand) {
                if (IndexDefinition.IndexKind.TEXT == defn.getKind() && !(operand instanceof FullTextSearch)) {
                    return false;
                }
                return super.applies(operand);
            }

            protected boolean indexAppliesTo(Or or) {
                boolean appliesToConstraints = super.indexAppliesTo(or);
                if (!appliesToConstraints) {
                    return false;
                }
                Collection joinConditions = calculator.joinConditions();
                if (joinConditions.isEmpty()) {
                    return true;
                }
                for (JoinCondition joinCondition : joinConditions) {
                    if (!(joinCondition instanceof ChildNodeJoinCondition) && !(joinCondition instanceof DescendantNodeJoinCondition)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

