/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.LuceneIndexProviderI18n;
import org.modeshape.jcr.index.lucene.MultiColumnIndex;
import org.modeshape.jcr.index.lucene.SingleColumnIndex;
import org.modeshape.jcr.index.lucene.TextIndex;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;
import org.modeshape.jcr.value.PropertyType;

@Immutable
public class LuceneManagedIndexBuilder
extends ManagedIndexBuilder {
    private final LuceneConfig luceneConfig;

    protected LuceneManagedIndexBuilder(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher, LuceneConfig luceneConfig) {
        super(context, defn, workspaceName, nodeTypesSupplier, matcher);
        assert (luceneConfig != null);
        this.luceneConfig = luceneConfig;
    }

    private Map<String, PropertyType> propertyTypesByName(IndexDefinition defn) {
        int size = defn.size();
        HashMap<String, PropertyType> result = new HashMap<String, PropertyType>(size);
        for (int i = 0; i < size; ++i) {
            IndexColumnDefinition columnDef = defn.getColumnDefinition(i);
            PropertyType propertyType = PropertyType.valueFor((int)columnDef.getColumnType());
            String propertyName = columnDef.getPropertyName();
            if (this.isPrimaryTypeIndex(columnDef, propertyType) || this.isMixinTypesIndex(columnDef, propertyType) || this.isNodeNameIndex(columnDef, propertyType)) {
                result.put(propertyName, PropertyType.NAME);
                continue;
            }
            if (this.isNodeLocalNameIndex(columnDef, propertyType)) {
                result.put(propertyName, PropertyType.STRING);
                continue;
            }
            if (this.isNodeDepthIndex(columnDef, propertyType)) {
                result.put(propertyName, PropertyType.LONG);
                continue;
            }
            if (this.isNodePathIndex(columnDef, propertyType)) {
                result.put(propertyName, PropertyType.PATH);
                continue;
            }
            result.put(propertyName, propertyType);
        }
        return result;
    }

    protected static void validate(IndexDefinition definition, Problems problems) {
        boolean isTextIndex;
        IndexDefinition.IndexKind kind = definition.getKind();
        boolean bl = isTextIndex = kind == IndexDefinition.IndexKind.TEXT;
        if (isTextIndex && definition.size() > 1) {
            problems.addError(LuceneIndexProviderI18n.multiColumnTextIndexesNotSupported, new Object[]{definition.getName()});
        }
        block4: for (int i = 0; i < definition.size(); ++i) {
            IndexColumnDefinition columnDef = definition.getColumnDefinition(i);
            PropertyType propertyType = PropertyType.valueFor((int)columnDef.getColumnType());
            switch (propertyType) {
                case OBJECT: {
                    problems.addError(LuceneIndexProviderI18n.invalidColumnType, new Object[]{propertyType, columnDef.getPropertyName(), definition.getName()});
                    continue block4;
                }
                case BINARY: {
                    if (isTextIndex) continue block4;
                    problems.addError(LuceneIndexProviderI18n.invalidColumnType, new Object[]{propertyType, columnDef.getPropertyName(), definition.getName()});
                }
            }
        }
    }

    protected ProvidedIndex<?> buildMultiValueIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        this.validate(defn);
        return defn.size() > 1 ? new MultiColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context) : new SingleColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context);
    }

    protected ProvidedIndex<?> buildUniqueValueIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        this.validate(defn);
        return defn.size() > 1 ? new MultiColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context) : new SingleColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context);
    }

    protected ProvidedIndex<?> buildEnumeratedIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        this.validate(defn);
        return defn.size() > 1 ? new MultiColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context) : new SingleColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context);
    }

    protected ProvidedIndex<?> buildTextIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        this.validate(defn);
        return new TextIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context);
    }

    protected ProvidedIndex<?> buildNodeTypeIndex(ExecutionContext context, IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        assert (defn.size() == 1);
        return new SingleColumnIndex(defn.getName(), workspaceName, this.luceneConfig, this.propertyTypesByName(defn), context);
    }

    private void validate(IndexDefinition defn) {
        SimpleProblems problems = new SimpleProblems();
        LuceneManagedIndexBuilder.validate(defn, (Problems)problems);
        if (problems.hasErrors()) {
            throw new LuceneIndexException(problems.toString());
        }
    }
}

