/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
public class ComparePathQuery
extends CompareQuery<Path> {
    private final ValueFactory<Path> pathFactory;

    protected ComparePathQuery(String fieldName, Path constraintPath, ValueFactory<Path> pathFactory, BiPredicate<Path, Path> evaluator, Function<String, String> caseOperation) {
        super(fieldName, constraintPath, evaluator, caseOperation);
        this.pathFactory = pathFactory;
    }

    @Override
    protected Path convertValue(String casedValue) {
        return (Path)this.pathFactory.create(casedValue);
    }

    public Query clone() {
        return new ComparePathQuery(this.field(), (Path)this.constraintValue, this.pathFactory, this.evaluator, this.caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathGreaterThan(Path constraintPath, String fieldName, ValueFactories factories, Function<String, String> caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (path1, path2) -> ValueComparators.PATH_COMPARATOR.compare(path1, path2) > 0, caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathGreaterThanOrEqualTo(Path constraintPath, String fieldName, ValueFactories factories, Function<String, String> caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (path1, path2) -> ValueComparators.PATH_COMPARATOR.compare(path1, path2) >= 0, caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathLessThan(Path constraintPath, String fieldName, ValueFactories factories, Function<String, String> caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (path1, path2) -> ValueComparators.PATH_COMPARATOR.compare(path1, path2) < 0, caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathLessThanOrEqualTo(Path constraintPath, String fieldName, ValueFactories factories, Function<String, String> caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (path1, path2) -> ValueComparators.PATH_COMPARATOR.compare(path1, path2) <= 0, caseOperation);
    }
}

