/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.index.lucene.query.RegexQuery;
import org.modeshape.jcr.query.engine.QueryUtil;
import org.modeshape.jcr.value.ValueComparators;

@Immutable
public class CompareStringQuery
extends CompareQuery<String> {
    private static final String LUCENE_SPECIAL_CHARACTERS = "+-&|!(){}[]^\"~?*:\\";

    protected CompareStringQuery(String fieldName, String constraintValue, BiPredicate<String, String> evaluator, Function<String, String> caseOperation) {
        super(fieldName, constraintValue, evaluator, caseOperation);
    }

    @Override
    protected String convertValue(String casedValue) {
        return casedValue;
    }

    public Query clone() {
        return new CompareStringQuery(this.field(), (String)this.constraintValue, this.evaluator, (Function<String, String>)this.caseOperation);
    }

    public static Query createQueryForNodesWithFieldEqualTo(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        return FieldComparison.EQ.createQueryForNodesWithField(constraintValue, fieldName, caseOperation);
    }

    public static Query createQueryForNodesWithFieldGreaterThan(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        return FieldComparison.GT.createQueryForNodesWithField(constraintValue, fieldName, caseOperation);
    }

    public static Query createQueryForNodesWithFieldGreaterThanOrEqualTo(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        return FieldComparison.GE.createQueryForNodesWithField(constraintValue, fieldName, caseOperation);
    }

    public static Query createQueryForNodesWithFieldLessThan(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        return FieldComparison.LT.createQueryForNodesWithField(constraintValue, fieldName, caseOperation);
    }

    public static Query createQueryForNodesWithFieldLessThanOrEqualTo(String constraintValue, String fieldName, Function<String, String> caseOperation) {
        return FieldComparison.LE.createQueryForNodesWithField(constraintValue, fieldName, caseOperation);
    }

    protected static Query createQueryForNodesWithFieldLike(String likeExpression, String fieldName, Function<String, String> caseOperation) {
        char firstChar;
        assert (likeExpression != null);
        assert (likeExpression.length() > 0);
        if (!QueryUtil.hasWildcardCharacters((String)likeExpression)) {
            return CompareStringQuery.createQueryForNodesWithFieldEqualTo(likeExpression, fieldName, caseOperation);
        }
        if (caseOperation == null && (firstChar = likeExpression.charAt(0)) != '%' && firstChar != '_' && firstChar != '*' && firstChar != '?') {
            return new WildcardQuery(new Term(fieldName, CompareStringQuery.toWildcardExpression(likeExpression)));
        }
        String regex = QueryUtil.toRegularExpression((String)likeExpression);
        Pattern pattern = Pattern.compile(regex, 64);
        return new RegexQuery(fieldName, pattern, caseOperation);
    }

    protected static String toWildcardExpression(String likeExpression) {
        if (likeExpression.isEmpty()) {
            return likeExpression;
        }
        int sz = likeExpression.length();
        StringBuilder buf = new StringBuilder(sz);
        int pos = -1;
        block5: while (++pos < sz) {
            char out;
            char c = likeExpression.charAt(pos);
            switch (c) {
                case '%': 
                case '*': {
                    buf.append('*');
                    continue block5;
                }
                case '?': 
                case '_': {
                    buf.append('?');
                    continue block5;
                }
                case '\\': {
                    if (++pos >= sz) continue block5;
                    out = likeExpression.charAt(pos);
                    break;
                }
                default: {
                    out = c;
                }
            }
            if (LUCENE_SPECIAL_CHARACTERS.indexOf(out) >= 0) {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static enum FieldComparison {
        EQ(cmp -> cmp == 0),
        GT(cmp -> cmp > 0),
        GE(cmp -> cmp >= 0),
        LT(cmp -> cmp < 0),
        LE(cmp -> cmp <= 0);

        final IntPredicate testCmp;

        private FieldComparison(IntPredicate testCmp) {
            this.testCmp = testCmp;
        }

        boolean test(int cmp) {
            return this.testCmp.test(cmp);
        }

        Query createQueryForNodesWithField(String constraintValue, String fieldName, Function<String, String> caseOperation) {
            constraintValue = QueryUtil.unescape((String)constraintValue);
            if (caseOperation == null) {
                if (this == EQ) {
                    return new TermQuery(new Term(fieldName, constraintValue));
                }
                return TermRangeQuery.newStringRange((String)fieldName, (String)(this.test(-1) ? null : constraintValue), (String)(this.test(1) ? null : constraintValue), (boolean)this.test(0), (boolean)this.test(0));
            }
            BiPredicate<String, String> evaluator = this == EQ ? Objects::equals : (s1, s2) -> this.test(ValueComparators.STRING_COMPARATOR.compare(s1, s2));
            return new CompareStringQuery(fieldName, constraintValue, evaluator, caseOperation);
        }
    }
}

