/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.datatype;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.TokenStream;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;

public class DataTypeParserTest
implements DdlConstants {
    private DataTypeParser parser;
    private boolean printTest = false;

    @Before
    public void beforeEach() {
        this.parser = new DataTypeParser();
    }

    private DdlTokenStream getTokens(String content) {
        DdlTokenStream tokens = new DdlTokenStream(content, (TokenStream.Tokenizer)DdlTokenStream.ddlTokenizer((boolean)false), false);
        tokens.start();
        return tokens;
    }

    private String getDataTypeString(String[] input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(input[i]);
        }
        return sb.toString();
    }

    private void printTest(String value) {
        if (this.printTest) {
            System.out.println("TEST:  " + value);
        }
    }

    @Test
    public void shouldParseBracketedInteger() {
        this.printTest("shouldParseBracketedInteger()");
        String content = "(255)";
        DdlTokenStream tokens = this.getTokens(content);
        long value = this.parser.parseBracketedLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)value);
    }

    @Test
    public void shouldParseKMGInteger() {
        this.printTest("shouldParseKMGInteger()");
        String content = "1000M";
        DdlTokenStream tokens = this.getTokens(content);
        long value = this.parser.parseLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)1048576000L, (long)value);
        content = "1000G";
        tokens = this.getTokens(content);
        value = this.parser.parseLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)0xFA00000000L, (long)value);
        content = "1000K";
        tokens = this.getTokens(content);
        value = this.parser.parseLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)1024000L, (long)value);
        content = "(1000M)";
        tokens = this.getTokens(content);
        value = this.parser.parseBracketedLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)1048576000L, (long)value);
        content = "(1000G)";
        tokens = this.getTokens(content);
        value = this.parser.parseBracketedLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)0xFA00000000L, (long)value);
        content = "(1000K)";
        tokens = this.getTokens(content);
        value = this.parser.parseBracketedLong(tokens, new DataType());
        Assert.assertEquals((String)"DataType length is not correct", (long)1024000L, (long)value);
    }

    @Test
    public void shouldParseCHAR() {
        String typeString;
        this.printTest("shouldParseCHAR()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_CHAR);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (255)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseCHARACTER() {
        String typeString;
        this.printTest("shouldParseCHARACTER()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_CHARACTER);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (255)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseCHAR_VARYING() {
        this.printTest("shouldParseCHAR_VARYING()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_CHAR_VARYING);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseCHARACTER_VARYING() {
        this.printTest("shouldParseCHARACTER_VARYING()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_CHARACTER_VARYING);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseVARCHAR() {
        this.printTest("shouldParseVARCHAR()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_VARCHAR);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
        content = typeString;
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldParseNATIONAL_CHAR() {
        String typeString;
        this.printTest("shouldParseNATIONAL_CHAR()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (255)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseNATIONAL_CHARACTER() {
        String typeString;
        this.printTest("shouldParseNATIONAL_CHARACTER()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (255)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseNATIONAL_CHAR_VARYING() {
        this.printTest("shouldParseNATIONAL_CHAR_VARYING()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR_VARYING);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseNATIONAL_CHARACTER_VARYING() {
        this.printTest("shouldParseNATIONAL_CHARACTER_VARYING()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER_VARYING);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseNCHAR_VARYING() {
        this.printTest("shouldParseNCHAR_VARYING()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_NCHAR_VARYING);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
        content = typeString;
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldParseBIT() {
        String typeString;
        this.printTest("shouldParseBIT()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_BIT);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseBITWithLength() {
        this.printTest("shouldParseBITWithLength()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_BIT);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
    }

    @Test
    public void shouldParseBIT_VARYINGWithLength() {
        this.printTest("shouldParseBIT_VARYINGWithLength()");
        String typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_BIT_VARYING);
        String content = typeString + " (255)";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)255L, (long)dType.getLength());
        content = typeString;
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldNotParseXXXXXXTYPE() {
        String typeString;
        this.printTest("shouldNotParseXXXXXXTYPE()");
        String content = typeString = "XXXXXXTYPE";
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + typeString), (Object)dType);
    }

    @Test
    public void shouldParseINT() {
        String typeString;
        this.printTest("shouldParseINT()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_INT);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseINTEGER() {
        String typeString;
        this.printTest("shouldParseINTEGER()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_INTEGER);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseSMALLINT() {
        String typeString;
        this.printTest("shouldParseSMALLINT()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_SMALLINT);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseNUMERIC() {
        String typeString;
        this.printTest("shouldParseNUMERIC()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_NUMERIC);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (5)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        content = typeString + " (5, 2)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        Assert.assertEquals((String)"DataType length is not correct", (long)2L, (long)dType.getScale());
        content = typeString + " (5  2)";
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
        content = typeString + " (5  A)";
        tokens = this.getTokens(content);
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldParseDECIMAL() {
        String typeString;
        this.printTest("shouldParseDECIMAL()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_DECIMAL);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (5)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        content = typeString + " (5, 2)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        Assert.assertEquals((String)"DataType length is not correct", (long)2L, (long)dType.getScale());
        content = typeString + " (5  2)";
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
        content = typeString + " (5  A)";
        tokens = this.getTokens(content);
        assert (dType == null);
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldParseDEC() {
        String typeString;
        this.printTest("shouldParseDEC()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_DEC);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (5)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        content = typeString + " (5, 2)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        Assert.assertEquals((String)"DataType length is not correct", (long)2L, (long)dType.getScale());
        content = typeString + " (5  2)";
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
        content = typeString + " (5  A)";
        tokens = this.getTokens(content);
        assert (dType == null);
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldParseFLOAT() {
        String typeString;
        this.printTest("shouldParseFLOAT()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_FLOAT);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (5)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)5L, (long)dType.getPrecision());
        content = typeString + " (5,  2)";
        tokens = this.getTokens(content);
        dType = null;
        try {
            dType = this.parser.parse(tokens);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        Assert.assertNull((String)("DataType should NOT have been found for Type = " + content), (Object)dType);
    }

    @Test
    public void shouldParseREAL() {
        String typeString;
        this.printTest("shouldParseREAL()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_REAL);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseDOUBLE_PRECISION() {
        String typeString;
        this.printTest("shouldParseDOUBLE_PRECISION()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_DOUBLE_PRECISION);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseDATE() {
        String typeString;
        this.printTest("shouldParseDATE()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_DATE);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
    }

    @Test
    public void shouldParseTIME() {
        String typeString;
        this.printTest("shouldParseTIME()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_TIME);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (6)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)6L, (long)dType.getPrecision());
    }

    @Test
    public void shouldParseTIMESTAMP() {
        String typeString;
        this.printTest("shouldParseTIMESTAMP()");
        String content = typeString = this.getDataTypeString(DdlConstants.DataTypes.DTYPE_TIMESTAMP);
        DdlTokenStream tokens = this.getTokens(content);
        DataType dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        content = typeString + " (6)";
        tokens = this.getTokens(content);
        dType = this.parser.parse(tokens);
        Assert.assertNotNull((String)("DataType was NOT found for Type = " + typeString), (Object)dType);
        Assert.assertEquals((String)"Wrong DataType found", (Object)typeString, (Object)dType.getName());
        Assert.assertEquals((String)"DataType length is not correct", (long)6L, (long)dType.getPrecision());
    }
}

