/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.odf;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class OdfMetadataSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceTextDocument() throws Exception {
        String filename = "text.odt";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.text"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:pages").getLong(), (Matcher)Is.is((Object)2L));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceTextTemplate() throws Exception {
        String filename = "text.ott";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.text-template"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:pages").getLong(), (Matcher)Is.is((Object)2L));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequencePresentation() throws Exception {
        String filename = "presentation.odp";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.presentation"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:pages").getLong(), (Matcher)Is.is((Object)2L));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequencePresentationTemplate() throws Exception {
        String filename = "presentation.otp";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.presentation-template"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:pages").getLong(), (Matcher)Is.is((Object)2L));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceSpreadsheet() throws Exception {
        String filename = "spreadsheet.ods";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.spreadsheet"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:sheets").getLong(), (Matcher)Is.is((Object)1L));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceSpreadsheetTemplate() throws Exception {
        String filename = "spreadsheet.ots";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.spreadsheet-template"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:sheets").getLong(), (Matcher)Is.is((Object)1L));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceDrawing() throws Exception {
        String filename = "drawing.odg";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.graphics"));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceDrawingTemplate() throws Exception {
        String filename = "drawing.otg";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.graphics-template"));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceChart() throws Exception {
        String filename = "chart.odc";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.chart"));
        this.assertCommonMetadata(sequencedNode);
    }

    @Test
    public void shouldSequenceChartTemplate() throws Exception {
        String filename = "chart.otc";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/odf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/vnd.oasis.opendocument.chart-template"));
        this.assertCommonMetadata(sequencedNode);
    }

    private void assertCommonMetadata(Node sequencedNode) throws Exception {
        Assert.assertThat((Object)sequencedNode.getProperty("odf:title").getString(), (Matcher)Is.is((Object)"Title"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:subject").getString(), (Matcher)Is.is((Object)"Subject"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:description").getString(), (Matcher)Is.is((Object)"Description"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:keywords").getValues()[0].getString(), (Matcher)Is.is((Object)"Keyword"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:keywords").getValues()[1].getString(), (Matcher)Is.is((Object)"Second keyword"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:generator").getString(), (Matcher)Is.is((Object)"Generator"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:creator").getString(), (Matcher)Is.is((Object)"Creator"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:language").getString(), (Matcher)Is.is((Object)"en"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:printedBy").getString(), (Matcher)Is.is((Object)"Printed by"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:initialCreator").getString(), (Matcher)Is.is((Object)"Initial creator"));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:editingCycles").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:editingTime").getLong(), (Matcher)Is.is((Object)666L));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:creationDate").getDate().get(1), (Matcher)Is.is((Object)2000));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:modificationDate").getDate().get(1), (Matcher)Is.is((Object)2005));
        Assert.assertThat((Object)sequencedNode.getProperty("odf:printDate").getDate().get(1), (Matcher)Is.is((Object)2010));
    }
}

