/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.pdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.pdf.PdfAttachmentMetadata;
import org.modeshape.sequencer.pdf.PdfBasicMetadata;
import org.modeshape.sequencer.pdf.PdfPageMetadata;
import org.modeshape.sequencer.pdf.PdfXmpMetadata;

public class PdfMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("pdf.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/pdf"});
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        Node sequencedNode = this.getPdfMetadataNode(outputNode);
        try {
            if (this.processBasicMetadata(sequencedNode, binaryValue)) {
                this.processXMPMetadata(sequencedNode, binaryValue);
                return true;
            }
            this.getLogger().warn("Ignoring pdf from node {0} because basic metadata cannot be extracted", new Object[]{inputProperty.getParent().getPath()});
            return false;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (ncdfe.getMessage().toLowerCase().contains("bouncycastle")) {
                this.getLogger().warn("Ignoring pdf from node {0} because it's encrypted and encrypted PDFs are not supported", new Object[]{inputProperty.getParent().getPath()});
                return false;
            }
            throw ncdfe;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processBasicMetadata(Node sequencedNode, Binary binaryValue) {
        PdfBasicMetadata metadata = null;
        try (InputStream stream = binaryValue.getStream();){
            metadata = new PdfBasicMetadata(stream);
            if (!metadata.check()) return false;
            this.setPropertyIfMetadataPresent(sequencedNode, "jcr:mimeType", "application/pdf");
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:pageCount", metadata.getPageCount());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:orientation", metadata.getOrientation());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:encrypted", metadata.isEncrypted());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:version", metadata.getVersion());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:author", metadata.getAuthor());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:creationDate", metadata.getCreationDate());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:creator", metadata.getCreator());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:keywords", metadata.getKeywords());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:modificationDate", metadata.getModificationDate());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:producer", metadata.getProducer());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:subject", metadata.getSubject());
            this.setPropertyIfMetadataPresent(sequencedNode, "pdf:title", metadata.getTitle());
            for (PdfPageMetadata pageMetadata : metadata.getPages()) {
                Node pageNode = sequencedNode.addNode("pdf:page", "pdf:page");
                this.setPropertyIfMetadataPresent(pageNode, "pdf:pageNumber", pageMetadata.getPageNumber());
                for (PdfAttachmentMetadata attachmentMetadata : pageMetadata.getAttachments()) {
                    Node attachmentNode = pageNode.addNode("pdf:attachment", "pdf:attachment");
                    this.setPropertyIfMetadataPresent(attachmentNode, "jcr:mimeType", attachmentMetadata.getMimeType());
                    this.setPropertyIfMetadataPresent(attachmentNode, "pdf:creationDate", attachmentMetadata.getCreationDate());
                    this.setPropertyIfMetadataPresent(attachmentNode, "pdf:modificationDate", attachmentMetadata.getModificationDate());
                    this.setPropertyIfMetadataPresent(attachmentNode, "pdf:subject", attachmentMetadata.getSubject());
                    this.setPropertyIfMetadataPresent(attachmentNode, "pdf:name", attachmentMetadata.getName());
                    this.setPropertyIfMetadataPresent(attachmentNode, "jcr:data", attachmentMetadata.getData());
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Couldn't process stream.", new Object[0]);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processXMPMetadata(Node sequencedNode, Binary binaryValue) {
        PdfXmpMetadata metadata = null;
        try (InputStream stream = binaryValue.getStream();){
            metadata = new PdfXmpMetadata(stream);
            if (!metadata.check()) return false;
            Node xmpNode = sequencedNode.addNode("pdf:xmp", "pdf:xmp");
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:baseURL", metadata.getBaseURL());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:createDate", metadata.getCreateDate());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:creatorTool", metadata.getCreatorTool());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:identifier", metadata.getIdentifier());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:metadataDate", metadata.getMetadataDate());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:modifyDate", metadata.getModifyDate());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:nickname", metadata.getNickname());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:rating", metadata.getRating());
            this.setPropertyIfMetadataPresent(xmpNode, "xmp:label", metadata.getLabel());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Couldn't process stream.", new Object[0]);
        }
        return false;
    }

    private Node getPdfMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("pdf:metadata");
            return outputNode;
        }
        return outputNode.addNode("pdf:metadata", "pdf:metadata");
    }

    private void setPropertyIfMetadataPresent(Node node, String propertyName, Object value) throws RepositoryException {
        if (value != null) {
            if (value instanceof String && !StringUtil.isBlank((String)((String)value))) {
                node.setProperty(propertyName, (String)value);
            } else if (value instanceof Boolean) {
                node.setProperty(propertyName, ((Boolean)value).booleanValue());
            } else if (value instanceof Long) {
                node.setProperty(propertyName, ((Long)value).longValue());
            } else if (value instanceof Integer) {
                node.setProperty(propertyName, new Long(((Integer)value).intValue()).longValue());
            } else if (value instanceof Calendar) {
                Calendar calendarValue = (Calendar)value;
                if (calendarValue.getTimeZone().getID().toLowerCase().equals("unknown")) {
                    calendarValue.setTimeZone(TimeZone.getDefault());
                }
                node.setProperty(propertyName, calendarValue);
            } else if (value instanceof byte[]) {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
                Binary binaryProperty = node.getSession().getValueFactory().createBinary((InputStream)is);
                node.setProperty(propertyName, binaryProperty);
            } else if (value instanceof List) {
                ValueFactory vf = node.getSession().getValueFactory();
                List<Value> values = ((List)value).stream().filter(val -> val instanceof String).map(val -> vf.createValue((String)val)).collect(Collectors.toList());
                if (!values.isEmpty()) {
                    node.setProperty(propertyName, values.toArray(new Value[values.size()]));
                }
            } else {
                throw new IllegalArgumentException(String.format("The value of the property %s has unknown type and couldn't be saved.", propertyName));
            }
        }
    }
}

