/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.wsdl.WSDLException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class WsdlSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldBeAbleToSequence_loanServicePT() throws Exception {
        this.assertSequencedSuccessfully("loanServicePT.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_stockQuote() throws Exception {
        this.assertSequencedSuccessfully("stockQuote.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_api_v3_portType() throws Exception {
        this.assertSequencedSuccessfully("uddi_api_v3_portType.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_custody_v3_binding() throws Exception {
        this.assertSequencedSuccessfully("uddi_custody_v3_binding.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_repl_v3_binding() throws Exception {
        this.assertSequencedSuccessfully("uddi_repl_v3_binding.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_repl_v3_portType() throws Exception {
        this.assertSequencedSuccessfully("uddi_repl_v3_portType.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_sub_v3_binding() throws Exception {
        this.assertSequencedSuccessfully("uddi_sub_v3_binding.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_sub_v3_portType() throws Exception {
        this.assertSequencedSuccessfully("uddi_sub_v3_portType.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_sbr_v3_binding() throws Exception {
        this.assertSequencedSuccessfully("uddi_subr_v3_binding.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_v3_service() throws Exception {
        this.assertSequencedSuccessfully("uddi_v3_service.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vs_v3_binding() throws Exception {
        this.assertSequencedSuccessfully("uddi_vs_v3_binding.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vs_v3_portType() throws Exception {
        this.assertSequencedSuccessfully("uddi_vs_v3_portType.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vscache_v3_binding() throws Exception {
        this.assertSequencedSuccessfully("uddi_vscache_v3_binding.wsdl");
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vscache_v3_portType() throws Exception {
        this.assertSequencedSuccessfully("uddi_vscache_v3_portType.wsdl");
    }

    @Test
    public void shouldFailIfWsdlInvalid() throws Throwable {
        String filename = "invalid.wsdl";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.rootNode.getNode("invalid.wsdl/jcr:content");
        this.expectSequencingFailure(sequencedNode);
        Map eventInfo = this.assertSequencingEventInfo(sequencedNode, this.session.getUserID(), "WSDL sequencer", sequencedNode.getPath(), "/wsdl");
        Assert.assertEquals((Object)WSDLException.class.getName(), (Object)eventInfo.get("sequencingFailureCause").getClass().getName());
    }

    private void assertSequencedSuccessfully(String filePath) throws Exception {
        Node parentNode = this.createNodeWithContentFromFile(filePath, filePath);
        Node wsdlDocument = this.getOutputNode(this.rootNode, "wsdl/" + filePath);
        Assert.assertNotNull((Object)wsdlDocument);
        Assert.assertEquals((Object)"wsdl:wsdlDocument", (Object)wsdlDocument.getPrimaryNodeType().getName());
        this.assertCreatedBySessionUser(wsdlDocument, (Session)this.session);
        Assert.assertTrue((wsdlDocument.getNodes().getSize() > 0L ? 1 : 0) != 0);
        Node sequencedNode = parentNode.getNode("jcr:content");
        this.assertSequencingEventInfo(sequencedNode, this.session.getUserID(), "WSDL sequencer", sequencedNode.getPath(), "/wsdl");
    }
}

