/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.sramp.AbstractSrampSequencer;
import org.modeshape.sequencer.xsd.XsdReader;

public class XsdSequencer
extends AbstractSrampSequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.initialize(registry, nodeTypeManager);
        this.registerNodeTypes("xsd.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/xsd", "application/xsd+xml", "application/xml", "text/xml"});
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("xs:schemaDocument");
        } else {
            outputNode = outputNode.addNode("xs:schemaDocument", "xs:schemaDocument");
        }
        try (InputStream stream = binaryValue.getStream();){
            new XsdReader(context).read(stream, outputNode);
        }
        return true;
    }

    public static final class MimeTypeConstants {
        public static final String APPLICATION_XML = "application/xml";
        public static final String TEXT_XML = "text/xml";
        @Deprecated
        public static final String XSD = "application/xsd";
        @Deprecated
        public static final String XSD_XML = "application/xsd+xml";
    }
}

