/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;

public class ModeShapeCmisClientTest {
    private Session session;

    @Before
    public void setUp() {
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.user", "dnauser");
        parameter.put("org.apache.chemistry.opencmis.password", "password");
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.serviceUrl("ACLService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.serviceUrl("/DiscoveryService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.serviceUrl("MultiFilingService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.serviceUrl("NavigationService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.serviceUrl("ObjectService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.serviceUrl("/PolicyService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.serviceUrl("RelationshipService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.serviceUrl("RepositoryService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.serviceUrl("VersioningService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", "cmis_repo:default");
        this.session = factory.createSession(parameter, null, (AuthenticationProvider)new StandardAuthenticationProvider(), null, null);
    }

    @Test
    public void shouldAccessRootFolder() throws Exception {
        Folder root = this.session.getRootFolder();
        System.out.println("Root: " + root);
    }

    @Test
    public void shouldObtainContentHashProperty() throws Exception {
        HashMap<String, String> folderProperties = new HashMap<String, String>();
        folderProperties.put("cmis:objectTypeId", "cmis:folder");
        folderProperties.put("cmis:name", "test");
        Folder folder = this.session.getRootFolder().createFolder(folderProperties);
        HashMap<String, String> fileProperties = new HashMap<String, String>();
        fileProperties.put("cmis:objectTypeId", "cmis:document");
        fileProperties.put("cmis:name", "file");
        String contents = "Hello";
        ContentStream cos = this.session.getObjectFactory().createContentStream("file", (long)contents.length(), "text/plain", (InputStream)new ByteArrayInputStream(contents.getBytes()));
        Document file = folder.createDocument(fileProperties, cos, VersioningState.MAJOR);
        file.getProperties();
        String s = file.getProperty("cmis:contentStreamHash").getValueAsString();
        Assert.assertEquals((Object)"{sha-1}f7ff9e8b7bb2e09b70935a5d785e0cc5d9d0abf0", (Object)s);
    }

    @Test
    public void testVersioning() throws Exception {
        HashMap<String, String> folderProperties = new HashMap<String, String>();
        folderProperties.put("cmis:objectTypeId", "cmis:folder");
        folderProperties.put("cmis:name", "test");
        Folder folder = this.session.getRootFolder().createFolder(folderProperties);
        HashMap<String, String> fileProperties = new HashMap<String, String>();
        fileProperties.put("cmis:objectTypeId", "cmis:document");
        fileProperties.put("cmis:name", "file");
        fileProperties.put("cmis:versionLabel", "initial");
        String[] contents = new String[]{"Hello World!", "Hello World", "Hello"};
        ContentStream cos = this.session.getObjectFactory().createContentStream("file", (long)contents[2].length(), "text/plain", (InputStream)new ByteArrayInputStream(contents[2].getBytes()));
        Document file = folder.createDocument(fileProperties, cos, VersioningState.MAJOR);
        ObjectId nextVersion = file.checkOut();
        Document file2 = (Document)this.session.getObject(nextVersion);
        cos = this.session.getObjectFactory().createContentStream("file", (long)contents[1].length(), "text/plain", (InputStream)new ByteArrayInputStream(contents[1].getBytes()));
        file2.checkIn(true, null, cos, "version1");
        nextVersion = file.checkOut();
        Document file3 = (Document)this.session.getObject(nextVersion);
        cos = this.session.getObjectFactory().createContentStream("file", (long)contents[0].length(), "text/plain", (InputStream)new ByteArrayInputStream(contents[0].getBytes()));
        file3.checkIn(true, null, cos, "version2");
        List versions = file.getAllVersions();
        Assert.assertEquals((long)3L, (long)versions.size());
        int i = 0;
        for (Document doc : versions) {
            String verId = doc.getId();
            Document versDoc = (Document)this.session.getObject(verId);
            String s = IoUtil.read((InputStream)versDoc.getContentStream().getStream());
            Assert.assertEquals((Object)contents[i], (Object)s);
            ++i;
        }
    }

    private String serviceUrl(String serviceMethod) {
        return "http://localhost:8090/modeshape-cmis/services/" + serviceMethod;
    }
}

