/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.modeshape.cmis.JcrMsVersion;

public class JcrMsVersionNode
extends JcrMsVersion {
    private final Version version;

    public JcrMsVersionNode(Node node, Version version, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, version, typeManager, pathManager, typeHandlerManager);
        this.version = version;
    }

    protected String getVersionSeriesId() {
        try {
            return this.version.getIdentifier();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    protected boolean isLatestVersion() throws RepositoryException {
        return true;
    }

    protected String getBaseNodeId() throws RepositoryException {
        return this.version.getIdentifier();
    }

    public boolean isVersionable() {
        return false;
    }

    public ObjectData compileObjectType(Set<String> filter, Boolean includeAllowableActions, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        try {
            ObjectDataImpl result = new ObjectDataImpl();
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            PropertiesImpl properties = new PropertiesImpl();
            filter = filter == null ? null : new HashSet<String>(filter);
            this.compileProperties(properties, filter, objectInfo);
            result.setProperties((Properties)properties);
            if (Boolean.TRUE.equals(includeAllowableActions)) {
                result.setAllowableActions(this.getAllowableActions());
            }
            if (requiresObjectInfo) {
                objectInfo.setObject((ObjectData)result);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

