/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.contents;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.contents.Contents;

public class PathControl
extends HLayout {
    private static final String PATH_SEPARATOR = "/";
    private final Label[] segments = new Label[50];
    private final Label[] separators = new Label[50];
    private final Label addButton = new Label();
    private final Label importButton = new Label();
    private final Label exportButton = new Label();

    public PathControl(final Contents contents) {
        this.setHeight(30);
        Label path = new Label();
        path.setAutoWidth();
        path.setContents("<b>Node:</b>");
        path.setStyleName("text");
        this.addMember((Canvas)path);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Label();
            this.segments[i].setAutoWidth();
            this.segments[i].setStyleName("segment");
            this.segments[i].addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Label label = (Label)event.getSource();
                    contents.getAndDisplayNode(label.getDataPath(), true);
                }
            });
            this.separators[i] = new Label();
            this.separators[i].setContents(PATH_SEPARATOR);
            this.separators[i].setVisible(false);
            this.separators[i].setAutoWidth();
            this.separators[i].setStyleName("segment-separator");
            this.separators[i].setMargin(Integer.valueOf(3));
            this.addMember((Canvas)this.segments[i]);
            this.addMember((Canvas)this.separators[i]);
        }
        this.addButton.setIcon("icons/add.png");
        this.addButton.setWidth(16);
        this.addButton.setTooltip("Add new node");
        this.addButton.setStyleName("button-label");
        this.addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                contents.showAddNodeDialog();
            }
        });
        this.importButton.setIcon("icons/folder_add.png");
        this.importButton.setWidth(16);
        this.importButton.setTooltip("Import nodes under this node");
        this.importButton.setStyleName("button-label");
        this.importButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                contents.showImportDialog();
            }
        });
        this.exportButton.setIcon("icons/folder_go.png");
        this.exportButton.setWidth(16);
        this.exportButton.setTooltip("Export this node");
        this.exportButton.setStyleName("button-label");
        this.exportButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                contents.showExportDialog();
            }
        });
        this.addMember((Canvas)this.addButton);
        this.addMember((Canvas)this.importButton);
        this.addMember((Canvas)this.exportButton);
    }

    public void display(String url) {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setContents("");
            this.separators[i].setVisible(false);
        }
        String[] tokens = url.split(PATH_SEPARATOR);
        if (tokens.length == 0) {
            tokens = new String[]{PATH_SEPARATOR};
        }
        for (int i = 0; i < tokens.length; ++i) {
            this.segments[i].setContents(tokens[i]);
            String path = "";
            for (int j = 0; j <= i; ++j) {
                path = path + PATH_SEPARATOR + this.segments[j].getContents();
            }
            this.segments[i].setTooltip(path);
            this.segments[i].setDataPath(path);
            this.segments[i].draw();
            if (i >= tokens.length - 1) continue;
            this.separators[i].setVisible(true);
        }
    }
}

