/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.modeshape.common.util.FileUtil;
import org.modeshape.web.server.Connector;
import org.modeshape.web.shared.RestoreParams;

public class BackupUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1505304380334878522L;
    private static final String CONTENT_PARAMETER = "Upload content";
    private static final String REPOSITORY_NAME_PARAMETER = "repository";
    private static final String INCLUDE_BINARY_PARAMETER = "Include binaries";
    private static final String REINDEX_ON_FINISH_PARAMETER = "Reindex on finish";
    private static final String REPOSITORY_CONNECTOR = "connector";
    private static final String DESTINATION_URL = "/tree/%s/";
    private ServletFileUpload upload;
    private File tempDir;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List items;
        try {
            items = this.upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
        String repository = this.getParameter(items, REPOSITORY_NAME_PARAMETER);
        String incBinaries = this.getParameter(items, INCLUDE_BINARY_PARAMETER);
        String reindexOnFinish = this.getParameter(items, REINDEX_ON_FINISH_PARAMETER);
        RestoreParams params = new RestoreParams();
        params.setIncludeBinaries(Boolean.valueOf(incBinaries));
        params.setReindexOnFinish(Boolean.valueOf(reindexOnFinish));
        InputStream in = this.getStream(items);
        File dir = new File(this.tempDir.getAbsolutePath() + File.pathSeparator + Long.toString(System.currentTimeMillis()));
        FileUtil.unzip((InputStream)in, (String)dir.getAbsolutePath());
        Connector connector = (Connector)request.getSession().getAttribute(REPOSITORY_CONNECTOR);
        try {
            connector.find(repository).restore(dir.getAbsolutePath(), params);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String uri = request.getContextPath() + String.format(DESTINATION_URL, repository);
        response.sendRedirect(uri);
    }

    private String getParameter(List<FileItem> items, String name) {
        for (FileItem i : items) {
            if (!i.isFormField() || !i.getFieldName().equals(name)) continue;
            return i.getString();
        }
        return null;
    }

    private InputStream getStream(List<FileItem> items) throws IOException {
        for (FileItem i : items) {
            if (i.isFormField() || !i.getFieldName().equals(CONTENT_PARAMETER)) continue;
            return i.getInputStream();
        }
        return null;
    }

    public void init() {
        DiskFileItemFactory diskFactory = new DiskFileItemFactory();
        ServletContext servletContext = this.getServletConfig().getServletContext();
        this.tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        diskFactory.setRepository(this.tempDir);
        this.upload = new ServletFileUpload((FileItemFactory)diskFactory);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

