/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.RepositoryManager;

public class RepositoryManagerTest {
    private final String VALID_JCR_URL = "file:src/test/resources/repo-config.json";
    protected final List<String> PARAM_NAMES = Collections.singletonList("org.modeshape.jcr.URL");
    private ServletContext context;

    @Before
    public void beforeEach() throws Exception {
        this.context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)this.context.getInitParameterNames()).thenAnswer(new Answer<Enumeration<?>>(){

            public Enumeration<?> answer(InvocationOnMock invocation) throws Throwable {
                return new Vector<String>(RepositoryManagerTest.this.PARAM_NAMES).elements();
            }
        });
        Mockito.when((Object)this.context.getInitParameter("org.modeshape.jcr.URL")).thenReturn((Object)"file:src/test/resources/repo-config.json");
    }

    @Test
    public void shouldLoadFileBasedModeShapeEngineFromClassPath() throws Exception {
        RepositoryManager.initialize((ServletContext)this.context);
        Set repoNames = RepositoryManager.getJcrRepositoryNames();
        Assert.assertThat((Object)repoNames, (Matcher)CoreMatchers.is(Collections.singleton("Test Repository")));
        Session session = RepositoryManager.getSession(null, (String)"Test Repository", (String)"default");
        Assert.assertThat((Object)session, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        try {
            String repoName = "xxxyyyzzz";
            RepositoryManager.getSession(null, (String)repoName, (String)"default");
            Assert.fail((String)("Should not have found repository \"" + repoName + "\""));
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            // empty catch block
        }
        RepositoryManager.shutdown();
    }
}

