/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.transformations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.ws.rs.WebApplicationException;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.backend.jena.GenericJenaBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.transform.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDPathTransform
implements Transformation<List<Map<String, Collection<Object>>>> {
    public static final String CONFIGURATION_FOLDER = "/fedora:system/fedora:transform/fedora:ldpath/";
    private static final Comparator<NodeType> BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    public static final String APPLICATION_RDF_LDPATH = "application/rdf+ldpath";
    private final InputStream query;
    private static final Logger LOGGER = LoggerFactory.getLogger(LDPathTransform.class);

    public LDPathTransform(InputStream query) {
        this.query = query;
    }

    public static LDPathTransform getNodeTypeTransform(Node node, String key) throws RepositoryException {
        Node programNode = node.getSession().getNode(CONFIGURATION_FOLDER + key);
        LOGGER.debug("Found program node: {}", (Object)programNode.getPath());
        NodeType primaryNodeType = node.getPrimaryNodeType();
        ImmutableSortedSet supertypes = ImmutableSortedSet.orderedBy(BY_NAME).add((Object[])primaryNodeType.getSupertypes()).build();
        ImmutableSortedSet mixinTypes = ImmutableSortedSet.orderedBy(BY_NAME).add((Object[])node.getMixinNodeTypes()).build();
        ImmutableList.Builder nodeTypesB = ImmutableList.builder();
        nodeTypesB.addAll((Iterable)mixinTypes).add((Object)primaryNodeType).addAll((Iterable)supertypes);
        mixinTypes.stream().map(mixin -> ImmutableSortedSet.orderedBy(BY_NAME).add((Object[])mixin.getDeclaredSupertypes()).build()).forEach(arg_0 -> ((ImmutableList.Builder)nodeTypesB).addAll(arg_0));
        ImmutableList nodeTypes = nodeTypesB.build();
        LOGGER.debug("Discovered node types: {}", (Object)nodeTypes);
        for (NodeType nodeType : nodeTypes) {
            if (!programNode.hasNode(nodeType.toString())) continue;
            return new LDPathTransform(programNode.getNode(nodeType.toString()).getNode("jcr:content").getProperty("jcr:data").getBinary().getStream());
        }
        throw new WebApplicationException((Throwable)new Exception("Couldn't find transformation for " + node.getPath() + " and transformation key " + key), 400);
    }

    @Override
    public List<Map<String, Collection<Object>>> apply(RdfStream stream) {
        LDPath<RDFNode> ldpathForResource = LDPathTransform.getLdpathResource(stream);
        Resource context = ResourceFactory.createResource((String)stream.topic().getURI());
        try {
            return ImmutableList.of(LDPathTransform.unsafeCast(ldpathForResource.programQuery((Object)context, (Reader)new InputStreamReader(this.query))));
        }
        catch (LDPathParseException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private static <F, T> T unsafeCast(F from) {
        return (T)from;
    }

    public boolean equals(Object other) {
        return other instanceof LDPathTransform && ((LDPathTransform)other).query.equals(this.query);
    }

    public int hashCode() {
        return Objects.hashCode(this.query);
    }

    private static LDPath<RDFNode> getLdpathResource(RdfStream rdfStream) {
        return new LDPath((RDFBackend)new GenericJenaBackend((Model)rdfStream.collect(RdfCollectors.toModel())));
    }
}

