/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.fcrepo.http.api.ContentExposingResource;
import org.fcrepo.kernel.api.exception.InvalidChecksumException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.models.FedoraBinary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.transform.TransformationFactory;
import org.fcrepo.transform.transformations.LDPathTransform;
import org.jvnet.hk2.annotations.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;

@Scope(value="request")
@Path(value="/{path: .*}/fcr:transform")
public class FedoraTransform
extends ContentExposingResource {
    @Inject
    protected Session session;
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraTransform.class);
    @Inject
    @Optional
    private TransformationFactory transformationFactory;
    @PathParam(value="path")
    protected String externalPath;

    public FedoraTransform() {
    }

    @VisibleForTesting
    public FedoraTransform(String externalPath) {
        this.externalPath = externalPath;
    }

    @PostConstruct
    public void setUpRepositoryConfiguration() throws RepositoryException, IOException {
        Session internalSession = this.sessions.getInternalSession();
        try {
            this.containerService.findOrCreate(internalSession, "/fedora:system/fedora:transform");
            ImmutableMap transformations = ImmutableMap.of((Object)"default", (Object)"/ldpath/default/ldpath_program.txt", (Object)"deluxe", (Object)"/ldpath/deluxe/ldpath_program.txt");
            transformations.forEach((key, value) -> {
                FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(internalSession, "/fedora:system/fedora:transform/fedora:ldpath/" + key);
                LOGGER.debug("Transformation default resource: {}", (Object)resource.getPath());
                Stream children = resource.getChildren();
                children.forEach(child -> LOGGER.debug("Child is {}", (Object)child.getPath()));
                String uploadPath = "/fedora:system/fedora:transform/fedora:ldpath/" + key + "/" + "fedora:Resource";
                if (!resource.getChildren().anyMatch(child -> child.getPath().equalsIgnoreCase(uploadPath))) {
                    LOGGER.debug("Uploading the stream to {}", (Object)uploadPath);
                    FedoraBinary base = (FedoraBinary)this.binaryService.findOrCreate(internalSession, uploadPath);
                    try {
                        base.setContent(((Object)((Object)this)).getClass().getResourceAsStream((String)value), null, null, null, null);
                    }
                    catch (InvalidChecksumException e) {
                        throw new RepositoryRuntimeException((Throwable)e);
                    }
                }
            });
            internalSession.save();
        }
        finally {
            internalSession.logout();
        }
    }

    @GET
    @Path(value="{program}")
    @Produces(value={"application/json"})
    @Timed
    public Object evaluateLdpathProgram(@PathParam(value="program") String program) throws RepositoryException {
        LOGGER.info("GET transform, '{}', for '{}'", (Object)program, (Object)this.externalPath);
        return LDPathTransform.getResourceTransform(this.resource(), this.session, this.nodeService, program).apply(this.getResourceTriples());
    }

    @POST
    @Consumes(value={"application/rdf+ldpath", "application/sparql-query"})
    @Produces(value={"application/json", "text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
    @Timed
    public Object evaluateTransform(@HeaderParam(value="Content-Type") MediaType contentType, InputStream requestBodyStream) {
        if (this.transformationFactory == null) {
            this.transformationFactory = new TransformationFactory();
        }
        LOGGER.info("POST transform for '{}'", (Object)this.externalPath);
        return this.transformationFactory.getTransform(contentType, requestBodyStream).apply(this.getResourceTriples());
    }

    protected Session session() {
        return this.session;
    }

    protected String externalPath() {
        return this.externalPath;
    }

    protected void addResourceHttpHeaders(FedoraResource resource) {
        throw new UnsupportedOperationException();
    }
}

