/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.transformations;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.backend.jena.GenericJenaBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.models.FedoraBinary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.transform.TransformNotFoundException;
import org.fcrepo.transform.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDPathTransform
implements Transformation<List<Map<String, Collection<Object>>>> {
    public static final String CONFIGURATION_FOLDER = "/fedora:system/fedora:transform/fedora:ldpath/";
    public static final String DEFAULT_TRANSFORM_RESOURCE = "fedora:Resource";
    public static final String APPLICATION_RDF_LDPATH = "application/rdf+ldpath";
    private final InputStream query;
    private static final Logger LOGGER = LoggerFactory.getLogger(LDPathTransform.class);

    public LDPathTransform(InputStream query) {
        this.query = query;
    }

    public static LDPathTransform getResourceTransform(FedoraResource resource, Session session, NodeService nodeService, String key) throws RepositoryException {
        FedoraResource transformResource = (FedoraResource)nodeService.find(session, CONFIGURATION_FOLDER + key);
        LOGGER.debug("Found transform resource: {}", (Object)transformResource.getPath());
        List rdfTypes = resource.getTypes();
        LOGGER.debug("Discovered rdf types: {}", (Object)rdfTypes);
        NamespaceRegistry nsRegistry = session.getWorkspace().getNamespaceRegistry();
        Function<URI, String> namespaceUriToPrefix = x -> {
            String uriString = x.toString();
            try {
                for (String namespace : nsRegistry.getURIs()) {
                    if (namespace.length() <= 0 || !uriString.startsWith(namespace)) continue;
                    return uriString.replace(namespace, nsRegistry.getPrefix(namespace) + ":");
                }
                return uriString;
            }
            catch (RepositoryException e) {
                return uriString;
            }
        };
        List rdfStringTypes = rdfTypes.stream().map(namespaceUriToPrefix).map(stringType -> transformResource.getPath() + "/" + stringType).collect(Collectors.toList());
        FedoraBinary transform = (FedoraBinary)transformResource.getChildren().filter(child -> rdfStringTypes.contains(child.getPath())).findFirst().orElseThrow(() -> new TransformNotFoundException(String.format("Couldn't find transformation for {} and transformation key {}", resource.getPath(), key)));
        return new LDPathTransform(transform.getContent());
    }

    @Override
    public List<Map<String, Collection<Object>>> apply(RdfStream stream) {
        LDPath<RDFNode> ldpathForResource = LDPathTransform.getLdpathResource(stream);
        Resource context = ResourceFactory.createResource((String)stream.topic().getURI());
        try {
            return ImmutableList.of(LDPathTransform.unsafeCast(ldpathForResource.programQuery((Object)context, (Reader)new InputStreamReader(this.query))));
        }
        catch (LDPathParseException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private static <F, T> T unsafeCast(F from) {
        return (T)from;
    }

    public boolean equals(Object other) {
        return other instanceof LDPathTransform && ((LDPathTransform)other).query.equals(this.query);
    }

    public int hashCode() {
        return Objects.hashCode(this.query);
    }

    private static LDPath<RDFNode> getLdpathResource(RdfStream rdfStream) {
        return new LDPath((RDFBackend)new GenericJenaBackend((Model)rdfStream.collect(RdfCollectors.toModel())));
    }
}

