/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.archiveindex;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.archiveindex.ArchiveIndexServices;
import org.ferris.astronomy.data.archiveindex.LoadResponseHandler;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForArchiveIndexAdmin;

public class ArchiveIndexServicesByPhp
implements ArchiveIndexServices {
    protected Logger log = Logger.getLogger(this.getClass());
    private static String PAGE = "/agb_handler.php";

    public void load(File data) throws AstronomyException {
        this.log.debug((Object)"Enter: load()");
        HttpRequestRunnerForArchiveIndexAdmin runner = new HttpRequestRunnerForArchiveIndexAdmin(PAGE);
        runner.addParameter(data);
        List list = runner.post(runner.getResource() + "?data_file=?", new LoadResponseHandler());
        this.log.info((Object)"Response from loading attempt:");
        Pattern p = Pattern.compile(".*ERROR:.*", 32);
        for (String line : list) {
            if (line.length() == 0) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                this.log.warn((Object)"Load failed", new Throwable(line));
                throw new AstronomyException(Code.ASTR000014, data, runner.getResource(), line);
            }
            this.log.info((Object)line);
        }
    }
}

